/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.kaazing.gateway.security.TypedCallbackHandlerMap;

public class DispatchCallbackHandler
implements CallbackHandler {
    private Map<Class<? extends Callback>, CallbackHandler> dispatchMap = new ConcurrentHashMap<Class<? extends Callback>, CallbackHandler>();

    public DispatchCallbackHandler register(Class<? extends Callback> callbackClass, CallbackHandler callbackHandler) {
        if (callbackClass == null) {
            throw new NullPointerException("callbackClass");
        }
        if (callbackHandler == null) {
            throw new NullPointerException("callbackHandler");
        }
        this.dispatchMap.put(callbackClass, callbackHandler);
        return this;
    }

    public DispatchCallbackHandler registerAll(TypedCallbackHandlerMap callbackHandlers) {
        if (callbackHandlers == null) {
            throw new NullPointerException("callbackHandlers");
        }
        this.dispatchMap.putAll(callbackHandlers.getMap());
        return this;
    }

    public CallbackHandler unregister(Class<? extends Callback> callbackClass) {
        if (callbackClass == null) {
            throw new NullPointerException("callbackClass");
        }
        this.dispatchMap.remove(callbackClass);
        return this;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (this.dispatchMap != null && this.dispatchMap.size() > 0) {
            if (callbacks != null && callbacks.length > 0) {
                for (Callback callback : callbacks) {
                    CallbackHandler handler;
                    if (callback != null) {
                        handler = this.dispatchMap.get(callback.getClass());
                        if (handler == null) {
                            throw new UnsupportedCallbackException(callback, "Could not find a handler for callback class " + callback.getClass().getName());
                        }
                    } else {
                        throw new UnsupportedCallbackException(callback, "A null callback was encountered in the callbacks provided.");
                    }
                    handler.handle(new Callback[]{callback});
                }
            }
        } else {
            throw new UnsupportedCallbackException(null, "No callback handlers are available.");
        }
    }

    Map<Class<? extends Callback>, CallbackHandler> getDispatchMap() {
        return this.dispatchMap;
    }
}

