/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.kaazing.gateway.security.auth.GenericCallback;

public class GenericCallbackHandler<T>
implements CallbackHandler {
    private final T object;
    private final Class<? extends GenericCallback> callbackClass;

    public GenericCallbackHandler(T o, Class<? extends GenericCallback> callbackClass) {
        this.object = o;
        this.callbackClass = callbackClass;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!this.callbackClass.isAssignableFrom(callback.getClass())) {
                throw new UnsupportedCallbackException(callback);
            }
            ((GenericCallback)callback).set(this.object);
        }
    }
}

