/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth.context;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.kaazing.gateway.security.LoginContextFactory;
import org.kaazing.gateway.security.TypedCallbackHandlerMap;
import org.kaazing.gateway.security.auth.AuthenticationTokenCallbackHandler;
import org.kaazing.gateway.security.auth.DefaultLoginResult;
import org.kaazing.gateway.security.auth.DispatchCallbackHandler;
import org.kaazing.gateway.security.auth.LoginResultCallbackHandler;
import org.kaazing.gateway.security.auth.context.LoginContextFactories;
import org.kaazing.gateway.security.auth.context.ResultAwareLoginContext;
import org.kaazing.gateway.security.auth.token.DefaultAuthenticationToken;
import org.kaazing.gateway.server.spi.security.AuthenticationTokenCallback;
import org.kaazing.gateway.server.spi.security.LoginResult;
import org.kaazing.gateway.server.spi.security.LoginResultCallback;
import org.slf4j.Logger;

public class DefaultLoginContextFactory
implements LoginContextFactory {
    protected static final Logger LOG = LoginContextFactories.getLogger();
    private static final String ERROR_MSG = "Failed to create a login context.";
    protected final String name;
    protected final Configuration configuration;

    protected boolean logEnabled() {
        return LOG.isTraceEnabled();
    }

    protected void log(String s, Object ... objs) {
        LOG.trace(String.format(s, objs));
    }

    public DefaultLoginContextFactory(String name, Configuration configuration) {
        this.name = name;
        this.configuration = configuration;
    }

    public String getName() {
        return this.name;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private DispatchCallbackHandler createDefaultCallbackHandler(LoginResult loginResult, TypedCallbackHandlerMap additionalCallbacks) {
        DispatchCallbackHandler handler = new DispatchCallbackHandler();
        handler.registerAll(additionalCallbacks);
        handler.register(LoginResultCallback.class, new LoginResultCallbackHandler(loginResult));
        return handler;
    }

    @Override
    public LoginContext createLoginContext(TypedCallbackHandlerMap additionalCallbacks) throws LoginException {
        try {
            DefaultLoginResult loginResult = new DefaultLoginResult();
            DispatchCallbackHandler handler = this.createDefaultCallbackHandler(loginResult, additionalCallbacks);
            this.defineAuthenticationTokenScheme(additionalCallbacks);
            return this.createLoginContext(handler, loginResult);
        }
        catch (Exception e) {
            String msg = String.format("%s", ERROR_MSG);
            if (this.logEnabled()) {
                LOG.trace(msg, (Throwable)e);
            }
            throw (LoginException)new LoginException(msg).initCause(e);
        }
    }

    private void defineAuthenticationTokenScheme(TypedCallbackHandlerMap additionalCallbacks) {
        String authorization;
        int spaceIdx;
        AuthenticationTokenCallbackHandler callbackHandler = additionalCallbacks.get(AuthenticationTokenCallback.class, AuthenticationTokenCallbackHandler.class);
        DefaultAuthenticationToken authToken = null;
        if (callbackHandler != null) {
            authToken = (DefaultAuthenticationToken)callbackHandler.getAuthToken();
        }
        if (authToken != null && !authToken.isEmpty() && authToken.getScheme() == null && (spaceIdx = (authorization = authToken.get()).indexOf(" ")) > 0) {
            String[] authorizationParts = new String[]{authorization.substring(0, spaceIdx), authorization.substring(spaceIdx + 1)};
            String authType = authorizationParts[0];
            authToken.setScheme(authType);
        }
    }

    @Override
    public LoginContext createLoginContext(Subject subject, final String username, final char[] password) throws LoginException {
        final DefaultLoginResult loginResult = new DefaultLoginResult();
        CallbackHandler handler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(username);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(password);
                        continue;
                    }
                    if (callback instanceof LoginResultCallback) {
                        ((LoginResultCallback)callback).setLoginResult((LoginResult)loginResult);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
        return this.createLoginContext(subject, handler, loginResult);
    }

    protected LoginContext createLoginContext(Subject subject, CallbackHandler handler, DefaultLoginResult loginResult) throws LoginException {
        return new ResultAwareLoginContext(this.name, subject, handler, this.configuration, loginResult);
    }

    protected LoginContext createLoginContext(CallbackHandler handler, DefaultLoginResult loginResult) throws LoginException {
        return this.createLoginContext(null, handler, loginResult);
    }
}

