/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.management.ManagementServiceHandler;
import org.kaazing.gateway.management.config.ClusterConfigurationBean;
import org.kaazing.gateway.management.config.NetworkConfigurationBean;
import org.kaazing.gateway.management.config.RealmConfigurationBean;
import org.kaazing.gateway.management.config.SecurityConfigurationBean;
import org.kaazing.gateway.management.config.ServiceConfigurationBean;
import org.kaazing.gateway.management.config.ServiceDefaultsConfigurationBean;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.jmx.ClusterConfigurationMXBeanImpl;
import org.kaazing.gateway.management.jmx.CpuListMXBeanImpl;
import org.kaazing.gateway.management.jmx.CpuMXBeanImpl;
import org.kaazing.gateway.management.jmx.GatewayMXBeanImpl;
import org.kaazing.gateway.management.jmx.HostMXBeanImpl;
import org.kaazing.gateway.management.jmx.JmxGatewayManagementListener;
import org.kaazing.gateway.management.jmx.JmxServiceManagementListener;
import org.kaazing.gateway.management.jmx.JmxSessionManagementListener;
import org.kaazing.gateway.management.jmx.JvmMXBeanImpl;
import org.kaazing.gateway.management.jmx.NetworkMappingMXBeanImpl;
import org.kaazing.gateway.management.jmx.NicListMXBeanImpl;
import org.kaazing.gateway.management.jmx.NicMXBeanImpl;
import org.kaazing.gateway.management.jmx.RealmMXBeanImpl;
import org.kaazing.gateway.management.jmx.SecurityMXBeanImpl;
import org.kaazing.gateway.management.jmx.ServiceConfigurationMXBeanImpl;
import org.kaazing.gateway.management.jmx.ServiceDefaultsConfigurationMXBeanImpl;
import org.kaazing.gateway.management.jmx.ServiceMXBean;
import org.kaazing.gateway.management.jmx.ServiceMXBeanImpl;
import org.kaazing.gateway.management.jmx.SessionMXBean;
import org.kaazing.gateway.management.jmx.SessionMXBeanImpl;
import org.kaazing.gateway.management.jmx.VersionInfoMXBeanImpl;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.management.session.SessionManagementBean;
import org.kaazing.gateway.management.system.CpuListManagementBean;
import org.kaazing.gateway.management.system.CpuManagementBean;
import org.kaazing.gateway.management.system.HostManagementBean;
import org.kaazing.gateway.management.system.JvmManagementBean;
import org.kaazing.gateway.management.system.NicListManagementBean;
import org.kaazing.gateway.management.system.NicManagementBean;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.server.Gateway;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.transport.BridgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmxManagementServiceHandler
implements ManagementServiceHandler {
    private static final String LOGGER_NAME = "management.jmx";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"management.jmx");
    public static final String JMX_OBJECT_NAME = Gateway.class.getPackage().getName() + ".management";
    private static final String GATEWAY_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,name=summary";
    private static final String SERVICE_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=services,serviceType=%s,serviceId=\"%s\",name=summary";
    private static final String SESSION_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=services,serviceType=%s,serviceId=\"%s\",name=sessions,sessionId=id-%d";
    private static final String CLUSTER_CONFIG_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=configuration,name=cluster,clusterName=%s";
    private static final String NETWORK_MAPPING_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=configuration,name=network-mappings,id=%d";
    private static final String SECURITY_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=configuration,name=security";
    private static final String REALM_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=configuration,name=realms,realm=%s";
    private static final String SERVICE_CONFIG_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=configuration,name=services,serviceType=%s,id=%d";
    private static final String SYSTEM_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=system,name=summary";
    private static final String CPU_LIST_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=system,name=CPUs/cores";
    private static final String NIC_LIST_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=system,name=NICs";
    private static final String JVM_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=jvm,name=summary";
    private static final String SERVICE_DEFAULTS_CONFIG_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=configuration,name=service-defaults";
    private static final String VERSION_INFO_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=configuration,name=version-info";
    private static final String CPU_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=system,name=CPUs/cores,id=%d";
    private static final String NIC_MBEAN_FORMAT_STR = "%s:root=gateways,gatewayId=%s,subtype=system,name=NICs,interfaceName=%s";
    private final AtomicLong notificationSequenceNumber = new AtomicLong(0L);
    protected final ServiceContext serviceContext;
    private final ManagementContext managementContext;
    private final MBeanServer mbeanServer;
    private final Map<Integer, ServiceMXBean> serviceBeanMap;
    private final Map<Long, SessionMXBean> sessionBeanMap;

    public JmxManagementServiceHandler(ServiceContext serviceContext, ManagementContext managementContext, MBeanServer mbeanServer) {
        this.serviceContext = serviceContext;
        this.managementContext = managementContext;
        this.mbeanServer = mbeanServer;
        this.serviceBeanMap = new HashMap<Integer, ServiceMXBean>();
        this.sessionBeanMap = new HashMap<Long, SessionMXBean>();
        managementContext.addGatewayManagementListener(new JmxGatewayManagementListener(this));
        managementContext.addServiceManagementListener(new JmxServiceManagementListener(this));
        managementContext.addSessionManagementListener(new JmxSessionManagementListener(this));
    }

    protected long nextNotificationSequenceNumber() {
        return this.notificationSequenceNumber.getAndIncrement();
    }

    @Override
    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public ServiceMXBean getServiceMXBean(int serviceId) {
        return this.serviceBeanMap.get(serviceId);
    }

    public SessionMXBean getSessionMXBean(long sessionId) {
        return this.sessionBeanMap.get(sessionId);
    }

    @Override
    public void addGatewayManagementBean(GatewayManagementBean gatewayManagementBean) {
        try {
            String hostAndPid = gatewayManagementBean.getHostAndPid();
            ObjectName name = new ObjectName(String.format(GATEWAY_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, hostAndPid));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Gateway MBean name %s already registered", name));
            } else {
                GatewayMXBeanImpl gatewayMXBean = new GatewayMXBeanImpl(name, gatewayManagementBean);
                this.mbeanServer.registerMBean(gatewayMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addServiceManagementBean(ServiceManagementBean serviceManagementBean) {
        try {
            GatewayManagementBean gatewayManagementBean = serviceManagementBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(SERVICE_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid(), this.replaceCharactersDisallowedInObjectName(serviceManagementBean.getServiceType()), serviceManagementBean.getServiceName()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Service MBean name %s already registered", name));
            } else {
                ServiceMXBeanImpl serviceMXBean = new ServiceMXBeanImpl(this, name, serviceManagementBean);
                this.mbeanServer.registerMBean(serviceMXBean, name);
                this.serviceBeanMap.put(serviceManagementBean.getId(), serviceMXBean);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addSessionManagementBean(SessionManagementBean sessionManagementBean) {
        try {
            ServiceManagementBean serviceManagementBean = sessionManagementBean.getServiceManagementBean();
            GatewayManagementBean gatewayManagementBean = serviceManagementBean.getGatewayManagementBean();
            ResourceAddress address = (ResourceAddress)BridgeSession.LOCAL_ADDRESS.get((IoSession)sessionManagementBean.getSession());
            ObjectName name = new ObjectName(String.format(SESSION_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid(), this.replaceCharactersDisallowedInObjectName(serviceManagementBean.getServiceType()), serviceManagementBean.getServiceName(), sessionManagementBean.getId()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Service MBean name %s already registered", name));
            } else {
                SessionMXBeanImpl sessionMXBean = new SessionMXBeanImpl(name, sessionManagementBean);
                this.mbeanServer.registerMBean(sessionMXBean, name);
                this.sessionBeanMap.put(sessionManagementBean.getId(), sessionMXBean);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void removeSessionManagementBean(SessionManagementBean sessionManagementBean) {
        try {
            ObjectName name;
            SessionMXBean sessionMXBean = this.sessionBeanMap.remove(sessionManagementBean.getId());
            if (sessionMXBean != null && this.mbeanServer.isRegistered(name = sessionMXBean.getObjectName())) {
                this.mbeanServer.unregisterMBean(name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addClusterConfigurationBean(ClusterConfigurationBean clusterConfigBean) {
        try {
            GatewayManagementBean gatewayManagementBean = clusterConfigBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(CLUSTER_CONFIG_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid(), ObjectName.quote(clusterConfigBean.getName())));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Cluster config MBean name %s already registered", name));
            } else {
                ClusterConfigurationMXBeanImpl clusterConfigMXBean = new ClusterConfigurationMXBeanImpl(name, clusterConfigBean);
                this.mbeanServer.registerMBean(clusterConfigMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addNetworkConfigurationBean(NetworkConfigurationBean networkMappingBean) {
        try {
            GatewayManagementBean gatewayManagementBean = networkMappingBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(NETWORK_MAPPING_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid(), networkMappingBean.getId()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Network mapping MBean name %s already registered", name));
            } else {
                NetworkMappingMXBeanImpl networkMappingMXBean = new NetworkMappingMXBeanImpl(name, networkMappingBean);
                this.mbeanServer.registerMBean(networkMappingMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addSecurityConfigurationBean(SecurityConfigurationBean securityBean) {
        try {
            GatewayManagementBean gatewayManagementBean = securityBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(SECURITY_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Realm MBean name %s already registered", name));
            } else {
                SecurityMXBeanImpl securityMXBean = new SecurityMXBeanImpl(name, securityBean);
                this.mbeanServer.registerMBean(securityMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addRealmConfigurationBean(RealmConfigurationBean realmBean) {
        try {
            GatewayManagementBean gatewayManagementBean = realmBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(REALM_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid(), realmBean.getName()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Realm MBean name %s already registered", name));
            } else {
                RealmMXBeanImpl realmMXBean = new RealmMXBeanImpl(name, realmBean);
                this.mbeanServer.registerMBean(realmMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addServiceConfigurationBean(ServiceConfigurationBean serviceConfigurationBean) {
        try {
            GatewayManagementBean gatewayManagementBean = serviceConfigurationBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(SERVICE_CONFIG_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid(), this.replaceCharactersDisallowedInObjectName(serviceConfigurationBean.getType()), serviceConfigurationBean.getId()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Service config MBean name %s already registered", name));
            } else {
                ServiceConfigurationMXBeanImpl serviceConfigurationMXBean = new ServiceConfigurationMXBeanImpl(name, serviceConfigurationBean);
                this.mbeanServer.registerMBean(serviceConfigurationMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addServiceDefaultsConfigurationBean(ServiceDefaultsConfigurationBean serviceDefaultsConfigurationBean) {
        try {
            GatewayManagementBean gatewayManagementBean = serviceDefaultsConfigurationBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(SERVICE_DEFAULTS_CONFIG_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Service defaults config MBean name %s already registered", name));
            } else {
                ServiceDefaultsConfigurationMXBeanImpl serviceDefaultsConfigurationMXBean = new ServiceDefaultsConfigurationMXBeanImpl(name, serviceDefaultsConfigurationBean);
                this.mbeanServer.registerMBean(serviceDefaultsConfigurationMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addVersionInfo(GatewayManagementBean gatewayManagementBean) {
        try {
            ObjectName name = new ObjectName(String.format(VERSION_INFO_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Version info MBean name %s already registered", name));
            } else {
                VersionInfoMXBeanImpl versionInfoMXBean = new VersionInfoMXBeanImpl(name, gatewayManagementBean);
                this.mbeanServer.registerMBean(versionInfoMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addSystemManagementBean(HostManagementBean systemManagementBean) {
        try {
            GatewayManagementBean gatewayManagementBean = systemManagementBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(SYSTEM_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Gateway system MBean name %s already registered", name));
            } else {
                HostMXBeanImpl systemMXBean = new HostMXBeanImpl(name, systemManagementBean);
                this.mbeanServer.registerMBean(systemMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addCpuListManagementBean(CpuListManagementBean cpuListManagementBean) {
        try {
            GatewayManagementBean gatewayManagementBean = cpuListManagementBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(CPU_LIST_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Gateway system MBean name %s already registered", name));
            } else {
                CpuListMXBeanImpl cpuListMXBean = new CpuListMXBeanImpl(name, cpuListManagementBean);
                this.mbeanServer.registerMBean(cpuListMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addNicListManagementBean(NicListManagementBean nicListManagementBean) {
        try {
            GatewayManagementBean gatewayManagementBean = nicListManagementBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(NIC_LIST_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Gateway system MBean name %s already registered", name));
            } else {
                NicListMXBeanImpl nicListMXBean = new NicListMXBeanImpl(name, nicListManagementBean);
                this.mbeanServer.registerMBean(nicListMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addCpuManagementBean(CpuManagementBean cpuManagementBean, String hostAndPid) {
        try {
            ObjectName name = new ObjectName(String.format(CPU_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, hostAndPid, cpuManagementBean.getId()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Gateway system CPU MBean name %s already registered", name));
            } else {
                CpuMXBeanImpl cpuMXBean = new CpuMXBeanImpl(name, cpuManagementBean);
                this.mbeanServer.registerMBean(cpuMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addNicManagementBean(NicManagementBean nicManagementBean, String hostAndPid) {
        try {
            String nicName = nicManagementBean.getName().replace(':', '_');
            ObjectName name = new ObjectName(String.format(NIC_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, hostAndPid, nicName));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Gateway system NetInterface MBean name %s already registered", name));
            } else {
                NicMXBeanImpl nicMXBean = new NicMXBeanImpl(name, nicManagementBean);
                this.mbeanServer.registerMBean(nicMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addJvmManagementBean(JvmManagementBean jvmManagementBean) {
        try {
            GatewayManagementBean gatewayManagementBean = jvmManagementBean.getGatewayManagementBean();
            ObjectName name = new ObjectName(String.format(JVM_MBEAN_FORMAT_STR, JMX_OBJECT_NAME, gatewayManagementBean.getHostAndPid()));
            if (this.mbeanServer.isRegistered(name)) {
                LOGGER.warn(String.format("Gateway JVM MBean name %s already registered", name));
            } else {
                JvmMXBeanImpl jvmMXBean = new JvmMXBeanImpl(name, jvmManagementBean);
                this.mbeanServer.registerMBean(jvmMXBean, name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void cleanupRegisteredBeans() {
        String gatewayId = ManagementFactory.getRuntimeMXBean().getName();
        this.cleanupRegisteredBeans(GATEWAY_MBEAN_FORMAT_STR, gatewayId);
        this.cleanupRegisteredBeans("%s:root=gateways,gatewayId=%s,subtype=services,*,name=summary", gatewayId);
        this.cleanupRegisteredBeans("%s:root=gateways,gatewayId=%s,subtype=configuration,*", gatewayId);
        this.cleanupRegisteredBeans("%s:root=gateways,gatewayId=%s,subtype=system,*", gatewayId);
        this.cleanupRegisteredBeans(JVM_MBEAN_FORMAT_STR, gatewayId);
    }

    private void cleanupRegisteredBeans(String formatString, String gatewayId) {
        try {
            ObjectName query = new ObjectName(String.format(formatString, JMX_OBJECT_NAME, gatewayId));
            Set<ObjectName> beanNames = this.mbeanServer.queryNames(null, query);
            for (ObjectName beanName : beanNames) {
                if (!this.mbeanServer.isRegistered(beanName)) continue;
                this.mbeanServer.unregisterMBean(beanName);
            }
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    private String replaceCharactersDisallowedInObjectName(String name) {
        return name.replace(':', '_');
    }
}

