/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.mib;

import org.json.JSONArray;
import org.json.JSONException;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.management.session.SessionManagementBean;
import org.kaazing.gateway.management.snmp.SummaryDataIntervalMO;
import org.kaazing.gateway.management.snmp.mib.MIBConstants;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.AgentCapabilityList;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SessionManagementMIB
implements MOGroup,
CounterListener,
AgentCapabilityList {
    private final ManagementContext managementContext;
    private DefaultMOTable sysOREntry;
    private DefaultMOMutableTableModel sysOREntryModel;
    private MOTableSubIndex[] sessionEntryIndexes;
    private MOTableIndex sessionEntryIndex;
    private MOTable sessionEntry;
    private MOTableModel sessionEntryModel;
    private MOScalar summaryDataFields;
    private MOScalar summaryDataNotificationInterval;

    public SessionManagementMIB(ManagementContext managementContext, MOFactory factory) {
        this.managementContext = managementContext;
        this.createMO(factory);
    }

    private void createMO(MOFactory moFactory) {
        OID serviceConfigEntryIndexOID = ((OID)MIBConstants.oidSessionEntry.clone()).append(1);
        this.sessionEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(serviceConfigEntryIndexOID, 2, 1, 1)};
        this.sessionEntryIndex = moFactory.createIndex(this.sessionEntryIndexes, true);
        MOColumn[] sessionEntryColumns = new MOColumn[]{new MOMutableColumn(1, 2, moFactory.createAccess(1)), new MOMutableColumn(2, 70, moFactory.createAccess(1)), new MOMutableColumn(3, 70, moFactory.createAccess(1)), new MOMutableColumn(4, 70, moFactory.createAccess(1)), new MOMutableColumn(5, 70, moFactory.createAccess(1)), new MOMutableColumn(6, 70, moFactory.createAccess(1)), new MOMutableColumn(7, 2, moFactory.createAccess(11)), new MOMutableColumn(8, 2, moFactory.createAccess(11)), new MOMutableColumn(9, 70, moFactory.createAccess(1)), new MOMutableColumn(10, 4, moFactory.createAccess(1)), new MOMutableColumn(11, 4, moFactory.createAccess(1)), new MOMutableColumn(12, 4, moFactory.createAccess(1)), new MOMutableColumn(13, 4, moFactory.createAccess(1)), new MOMutableColumn(14, 4, moFactory.createAccess(1))};
        this.sessionEntryModel = new SessionManagementTableModel();
        this.sessionEntry = moFactory.createTable(MIBConstants.oidSessionEntry, this.sessionEntryIndex, sessionEntryColumns, this.sessionEntryModel);
        try {
            JSONArray jsonArray = new JSONArray((Object)SessionManagementBean.SUMMARY_DATA_FIELD_LIST);
            this.summaryDataFields = new MOScalar(MIBConstants.oidSessionSummaryDataFields, moFactory.createAccess(1), (Variable)new OctetString(jsonArray.toString()));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.summaryDataNotificationInterval = new SummaryDataIntervalMO(moFactory, this.managementContext.getSessionSummaryDataNotificationInterval(), MIBConstants.oidSessionSummaryDataNotificationInterval);
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register((ManagedObject)this.sessionEntry, context);
        server.register((ManagedObject)this.summaryDataFields, context);
        server.register((ManagedObject)this.summaryDataNotificationInterval, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister((ManagedObject)this.sessionEntry, context);
        server.unregister((ManagedObject)this.summaryDataFields, context);
        server.unregister((ManagedObject)this.summaryDataNotificationInterval, context);
    }

    public void incrementCounter(CounterEvent event) {
    }

    public OID addSysOREntry(OID sysORID, OctetString sysORDescr) {
        OID index = new OID(new int[]{this.sysOREntryModel.getRowCount() + 1});
        Variable[] values = new Variable[this.sysOREntry.getColumnCount()];
        int n = 0;
        values[n++] = sysORID;
        values[n++] = sysORDescr;
        DefaultMOTableRow row = new DefaultMOTableRow(index, values);
        this.sysOREntry.addRow((MOTableRow)row);
        return index;
    }

    public MOTableRow removeSysOREntry(OID index) {
        return this.sysOREntry.removeRow(index);
    }

    public OID addSessionBean(SessionManagementBean bean) {
        ServiceManagementBean serviceBean = bean.getServiceManagementBean();
        GatewayManagementBean gatewayBean = serviceBean.getGatewayManagementBean();
        OID sessionIndexOID = new OID(new int[]{gatewayBean.getId(), serviceBean.getId(), (int)bean.getId()});
        this.sessionEntry.addRow((MOTableRow)new SessionEntryRow(sessionIndexOID, bean));
        return sessionIndexOID;
    }

    public void removeSessionBean(OID oid) {
        this.sessionEntry.removeRow(oid);
    }

    private final class SessionEntryRow
    extends DefaultMOMutableRow2PC {
        private SessionManagementBean bean;

        private SessionEntryRow(OID index, SessionManagementBean bean) {
            super(index, null);
            this.bean = bean;
        }

        public int size() {
            return 14;
        }

        public Variable getValue(int column) {
            Number scalarValue = null;
            try {
                switch (column) {
                    case 0: {
                        return new Integer32(this.getIndex().last());
                    }
                    case 1: {
                        scalarValue = this.bean.getId();
                        break;
                    }
                    case 2: {
                        scalarValue = this.bean.getReadBytes();
                        break;
                    }
                    case 3: {
                        scalarValue = this.bean.getReadBytesThroughput();
                        break;
                    }
                    case 4: {
                        scalarValue = this.bean.getWrittenBytes();
                        break;
                    }
                    case 5: {
                        scalarValue = this.bean.getWrittenBytesThroughput();
                        break;
                    }
                    case 6: {
                        return new Integer32(1);
                    }
                    case 7: {
                        return new Integer32(this.bean.areNotificationsEnabled() ? 1 : 0);
                    }
                    case 8: {
                        scalarValue = this.bean.getCreateTime();
                        break;
                    }
                    case 9: {
                        return Utils.stringToVariable(this.bean.getRemoteAddress());
                    }
                    case 10: {
                        return Utils.stringToVariable(this.bean.getUserPrincipals());
                    }
                    case 11: {
                        return Utils.stringToVariable(this.bean.getSessionTypeName());
                    }
                    case 12: {
                        return Utils.stringToVariable(this.bean.getSessionDirection());
                    }
                    case 13: {
                        return Utils.stringToVariable(this.bean.getSummaryData());
                    }
                    default: {
                        return super.getValue(column);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (scalarValue == null) {
                return new Null();
            }
            long counterValue = scalarValue instanceof Double ? (long)((Double)scalarValue * 1000.0) : (scalarValue instanceof Float ? (long)(((Float)scalarValue).floatValue() * 1000.0f) : ((Number)scalarValue).longValue());
            return new Counter64(counterValue);
        }

        public void commit(SubRequest subRequest, MOTableRow changeSet, int column) {
            this.setValue(column, (Variable)subRequest.getVariableBinding().getVariable().clone());
            subRequest.completed();
        }

        public void setValue(int column, Variable newValue) {
            switch (column) {
                case 6: {
                    if (!(newValue instanceof Integer32) || ((Integer32)newValue).getValue() != 0) break;
                    this.bean.close();
                    SessionManagementMIB.this.removeSessionBean(this.getIndex());
                    break;
                }
                case 7: {
                    if (!(newValue instanceof Integer32)) break;
                    this.bean.enableNotifications(((Integer32)newValue).getValue() == 1);
                    break;
                }
                default: {
                    super.setValue(column, newValue);
                }
            }
        }
    }

    private class SessionManagementTableModel
    extends DefaultMOMutableTableModel {
        private SessionManagementTableModel() {
        }
    }
}

