/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp;

import java.io.IOException;
import java.util.Vector;
import org.snmp4j.PDU;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.smi.VariableBinding;

public class KaazingPDU
extends PDU {
    public static final int KAAZING_NOTIFICATION_SUBSCRIPTION = -86;
    public static final int GETSUBTREE = -85;

    public KaazingPDU() {
    }

    public KaazingPDU(PDU other) {
        super(other);
    }

    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte pduType = new BER.MutableByte();
        int length = BER.decodeHeader((BERInputStream)inputStream, (BER.MutableByte)pduType);
        int pduStartPos = (int)inputStream.getPosition();
        switch (pduType.getValue()) {
            case -93: {
                break;
            }
            case -96: {
                break;
            }
            case -95: {
                break;
            }
            case -91: {
                break;
            }
            case -90: {
                break;
            }
            case -88: {
                break;
            }
            case -89: {
                break;
            }
            case -94: {
                break;
            }
            case -85: {
                break;
            }
            case -86: {
                break;
            }
            default: {
                throw new IOException("Unsupported PDU type: " + pduType.getValue());
            }
        }
        this.type = pduType.getValue();
        if (length == 0) {
            return;
        }
        this.requestID.decodeBER(inputStream);
        this.errorStatus.decodeBER(inputStream);
        this.errorIndex.decodeBER(inputStream);
        pduType = new BER.MutableByte();
        int vbLength = BER.decodeHeader((BERInputStream)inputStream, (BER.MutableByte)pduType);
        if (pduType.getValue() != 48) {
            throw new IOException("Encountered invalid tag, SEQUENCE expected: " + pduType.getValue());
        }
        int startPos = (int)inputStream.getPosition();
        this.variableBindings = new Vector();
        while (inputStream.getPosition() - (long)startPos < (long)vbLength) {
            VariableBinding vb = new VariableBinding();
            vb.decodeBER(inputStream);
            this.variableBindings.add(vb);
        }
        if (inputStream.getPosition() - (long)startPos != (long)vbLength) {
            throw new IOException("Length of VB sequence (" + vbLength + ") does not match real length: " + ((int)inputStream.getPosition() - startPos));
        }
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength((int)length, (int)((int)inputStream.getPosition() - pduStartPos), (BERSerializable)this);
        }
    }

    public Object clone() {
        return new KaazingPDU(this);
    }

    public static String getTypeString(int type) {
        if (type == -85) {
            return "GETSUBTREE";
        }
        if (type == -86) {
            return "KAAZING_NOTIFICATION_SUBSCRIPTION";
        }
        return PDU.getTypeString((int)type);
    }

    public static int getTypeFromString(String type) {
        if (type.equals("GETSUBTREE")) {
            return -85;
        }
        if (type.equals("KAAZING_NOTIFICATION_SUBSCRIPTION")) {
            return -86;
        }
        return PDU.getTypeFromString((String)type);
    }
}

