/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.monitoring.entity.manager.impl;

import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.monitoring.entity.manager.ServiceCounterManager;
import org.kaazing.gateway.service.LongMonitoringCounter;
import org.kaazing.gateway.service.MonitoringEntityFactory;

public class ServiceCounterManagerImpl
implements ServiceCounterManager {
    private static final String CURRENT_NUMBER_OF_SESSIONS = "current-number-of-sessions";
    private static final String CURRENT_NUMBER_OF_NATIVE_SESSIONS = "current-number-of-native-sessions";
    private static final String CURRENT_NUMBER_OF_EMULATED_SESSIONS = "current-number-of-emulated-sessions";
    private static final String CUMULATIVE_NUMBER_OF_SESSIONS = "cumulative-number-of-sessions";
    private static final String CUMULATIVE_NUMBER_OF_NATIVE_SESSIONS = "cumulative-number-of-native-sessions";
    private static final String CUMULATIVE_NUMBER_OF_EMULATED_SESSIONS = "cumulative-number-of-emulated-sessions";
    private LongMonitoringCounter numberOfSessionsCounter;
    private LongMonitoringCounter numberOfNativeSessionsCounter;
    private LongMonitoringCounter numberOfEmulatedSessionsCounter;
    private LongMonitoringCounter cumulativeSessionsCounter;
    private LongMonitoringCounter cumulativeNativeSessionsCounter;
    private LongMonitoringCounter cumulativeEmulatedSessionsCounter;
    private MonitoringEntityFactory monitoringEntityFactory;

    public ServiceCounterManagerImpl(MonitoringEntityFactory monitoringEntityFactory) {
        this.monitoringEntityFactory = monitoringEntityFactory;
        this.initializeSessionCounters();
    }

    @Override
    public void incrementSessionCounters(Utils.ManagementSessionType managementSessionType) {
        this.numberOfSessionsCounter = this.numberOfSessionsCounter.increment();
        this.cumulativeSessionsCounter = this.cumulativeSessionsCounter.increment();
        if (managementSessionType.equals((Object)Utils.ManagementSessionType.NATIVE)) {
            this.numberOfNativeSessionsCounter = this.numberOfNativeSessionsCounter.increment();
            this.cumulativeNativeSessionsCounter = this.cumulativeNativeSessionsCounter.increment();
        } else if (managementSessionType.equals((Object)Utils.ManagementSessionType.EMULATED)) {
            this.numberOfEmulatedSessionsCounter = this.numberOfEmulatedSessionsCounter.increment();
            this.cumulativeEmulatedSessionsCounter = this.cumulativeEmulatedSessionsCounter.increment();
        }
    }

    @Override
    public void decrementSessionCounters(Utils.ManagementSessionType managementSessionType) {
        this.numberOfSessionsCounter = this.numberOfSessionsCounter.decrement();
        if (managementSessionType.equals((Object)Utils.ManagementSessionType.NATIVE)) {
            this.numberOfNativeSessionsCounter = this.numberOfNativeSessionsCounter.decrement();
        } else if (managementSessionType.equals((Object)Utils.ManagementSessionType.EMULATED)) {
            this.numberOfEmulatedSessionsCounter = this.numberOfEmulatedSessionsCounter.decrement();
        }
    }

    public LongMonitoringCounter makeLongMonitoringCounter(String name) {
        return this.monitoringEntityFactory.makeLongMonitoringCounter(name);
    }

    public void close() {
        this.monitoringEntityFactory.close();
    }

    public LongMonitoringCounter numberOfSessionsCounter() {
        return this.numberOfSessionsCounter;
    }

    public LongMonitoringCounter numberOfNativeSessionsCounter() {
        return this.numberOfNativeSessionsCounter;
    }

    public LongMonitoringCounter numberOfEmulatedSessionsCounter() {
        return this.numberOfEmulatedSessionsCounter;
    }

    public LongMonitoringCounter cumulativeSessionsCounter() {
        return this.cumulativeSessionsCounter;
    }

    public LongMonitoringCounter cumulativeNativeSessionsCounter() {
        return this.cumulativeNativeSessionsCounter;
    }

    public LongMonitoringCounter cumulativeEmulatedSessionsCounter() {
        return this.cumulativeEmulatedSessionsCounter;
    }

    private void initializeSessionCounters() {
        if (this.monitoringEntityFactory == null) {
            return;
        }
        this.numberOfSessionsCounter = this.monitoringEntityFactory.makeLongMonitoringCounter(CURRENT_NUMBER_OF_SESSIONS);
        this.numberOfNativeSessionsCounter = this.monitoringEntityFactory.makeLongMonitoringCounter(CURRENT_NUMBER_OF_NATIVE_SESSIONS);
        this.numberOfEmulatedSessionsCounter = this.monitoringEntityFactory.makeLongMonitoringCounter(CURRENT_NUMBER_OF_EMULATED_SESSIONS);
        this.cumulativeSessionsCounter = this.monitoringEntityFactory.makeLongMonitoringCounter(CUMULATIVE_NUMBER_OF_SESSIONS);
        this.cumulativeNativeSessionsCounter = this.monitoringEntityFactory.makeLongMonitoringCounter(CUMULATIVE_NUMBER_OF_NATIVE_SESSIONS);
        this.cumulativeEmulatedSessionsCounter = this.monitoringEntityFactory.makeLongMonitoringCounter(CUMULATIVE_NUMBER_OF_EMULATED_SESSIONS);
    }
}

