/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp;

import com.hazelcast.core.IMap;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.mina.core.service.IoHandler;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.Uptime;
import org.kaazing.gateway.management.ManagementService;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.snmp.SnmpManagementServiceHandler;
import org.kaazing.gateway.security.SecurityContext;
import org.kaazing.gateway.server.context.resolve.DefaultSecurityContext;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.messaging.collections.CollectionsFactory;
import org.kaazing.gateway.util.InternalSystemProperty;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class SnmpManagementService
implements ManagementService {
    private static final Logger logger = LoggerFactory.getLogger(SnmpManagementService.class);
    private ManagementContext managementContext;
    private SnmpManagementServiceHandler handler;
    private ServiceContext serviceContext;
    private DefaultSecurityContext securityContext;
    private Properties configuration;
    private boolean systemStatsSupported = true;

    public void destroy() throws Exception {
    }

    @Override
    public void init() {
    }

    public String getType() {
        return "management.snmp";
    }

    @Resource(name="configuration")
    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    @Resource(name="securityContext")
    public void setSecurityContext(DefaultSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Resource(name="managementContext")
    public void setManagementContext(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    public void init(ServiceContext serviceContext) throws Exception {
        try {
            Sigar sigar = new Sigar();
            Uptime uptime = sigar.getUptime();
        }
        catch (Throwable t) {
            logger.info("SNMP management service: Unable to access system-level management statistics");
            logger.info("  (CPU, NIC, System data). Management will continue without them.");
            this.systemStatsSupported = false;
        }
        this.serviceContext = serviceContext;
        this.handler = new SnmpManagementServiceHandler(serviceContext, this.managementContext);
        this.managementContext.setManagementSessionThreshold(InternalSystemProperty.MANAGEMENT_SESSION_THRESHOLD.getIntProperty(this.configuration));
        this.managementContext.addManagementServiceHandler(this.handler);
        this.managementContext.setActive(true);
    }

    public void quiesce() throws Exception {
        this.serviceContext.unbind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
    }

    public void start() throws Exception {
        this.managementContext.updateManagementContext((SecurityContext)this.securityContext);
        this.serviceContext.bind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
        ClusterContext clusterContext = this.managementContext.getCluster();
        CollectionsFactory factory = clusterContext.getCollectionsFactory();
        IMap managementServiceUriMap = factory.getMap("managementServiceMap");
        managementServiceUriMap.put(clusterContext.getLocalMember(), this.serviceContext.getAccepts());
    }

    public void stop() throws Exception {
        this.quiesce();
        for (IoSessionEx session : this.serviceContext.getActiveSessions()) {
            session.close(true);
        }
    }

    public void removeGatewayBean(OID oid) {
        this.handler.removeGatewayBean(oid);
    }

    public void removeServiceBean(OID oid) {
        this.handler.removeServiceBean(oid);
    }

    public void removeSessionBean(OID oid) {
        this.handler.removeSessionBean(oid);
    }

    public void sendNotification(OID oid, VariableBinding[] variableBindings) {
        this.handler.sendNotification(oid, variableBindings);
    }
}

