/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.context;

import com.hazelcast.core.EntryListener;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.kaazing.gateway.management.ManagementServiceHandler;
import org.kaazing.gateway.management.ManagementStrategy;
import org.kaazing.gateway.management.ManagementStrategyChangeListener;
import org.kaazing.gateway.management.SummaryManagementInterval;
import org.kaazing.gateway.management.config.ClusterConfigurationBean;
import org.kaazing.gateway.management.config.ClusterConfigurationBeanImpl;
import org.kaazing.gateway.management.config.RealmConfigurationBean;
import org.kaazing.gateway.management.config.RealmConfigurationBeanImpl;
import org.kaazing.gateway.management.config.SecurityConfigurationBean;
import org.kaazing.gateway.management.config.SecurityConfigurationBeanImpl;
import org.kaazing.gateway.management.config.ServiceConfigurationBean;
import org.kaazing.gateway.management.config.ServiceConfigurationBeanImpl;
import org.kaazing.gateway.management.config.ServiceDefaultsConfigurationBean;
import org.kaazing.gateway.management.config.ServiceDefaultsConfigurationBeanImpl;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.filter.FullManagementFilterStrategy;
import org.kaazing.gateway.management.filter.ManagementFilter;
import org.kaazing.gateway.management.filter.ManagementFilterStrategy;
import org.kaazing.gateway.management.filter.PassThruManagementFilterStrategy;
import org.kaazing.gateway.management.filter.ServiceOnlyManagementFilterStrategy;
import org.kaazing.gateway.management.gateway.CollectOnlyManagementGatewayStrategy;
import org.kaazing.gateway.management.gateway.FullManagementGatewayStrategy;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.gateway.GatewayManagementBeanImpl;
import org.kaazing.gateway.management.gateway.GatewayManagementListener;
import org.kaazing.gateway.management.gateway.ManagementGatewayStrategy;
import org.kaazing.gateway.management.service.CollectOnlyManagementServiceStrategy;
import org.kaazing.gateway.management.service.FullManagementServiceStrategy;
import org.kaazing.gateway.management.service.ManagementServiceStrategy;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.management.service.ServiceManagementBeanFactory;
import org.kaazing.gateway.management.service.ServiceManagementListener;
import org.kaazing.gateway.management.session.CollectOnlyManagementSessionStrategy;
import org.kaazing.gateway.management.session.FullManagementSessionStrategy;
import org.kaazing.gateway.management.session.ManagementSessionStrategy;
import org.kaazing.gateway.management.session.SessionManagementBean;
import org.kaazing.gateway.management.session.SessionManagementBeanImpl;
import org.kaazing.gateway.management.session.SessionManagementListener;
import org.kaazing.gateway.management.system.CpuListManagementBeanImpl;
import org.kaazing.gateway.management.system.CpuManagementBean;
import org.kaazing.gateway.management.system.FullManagementSystemStrategy;
import org.kaazing.gateway.management.system.HostManagementBeanImpl;
import org.kaazing.gateway.management.system.JvmManagementBeanImpl;
import org.kaazing.gateway.management.system.ManagementSystemStrategy;
import org.kaazing.gateway.management.system.NicListManagementBeanImpl;
import org.kaazing.gateway.management.system.NicManagementBean;
import org.kaazing.gateway.management.system.NullManagementSystemStrategy;
import org.kaazing.gateway.management.system.SystemDataProvider;
import org.kaazing.gateway.management.system.SystemDataProviderFactory;
import org.kaazing.gateway.security.RealmContext;
import org.kaazing.gateway.security.SecurityContext;
import org.kaazing.gateway.server.context.DependencyContext;
import org.kaazing.gateway.server.context.GatewayContext;
import org.kaazing.gateway.server.context.ServiceDefaultsContext;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.util.InternalSystemProperty;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;
import org.kaazing.mina.core.session.IoSessionEx;

public class DefaultManagementContext
implements ManagementContext,
DependencyContext {
    public static final int DEFAULT_SUMMARY_DATA_NOTIFICATION_INTERVAL = 5000;
    public static final int DEFAULT_SYSTEM_SUMMARY_DATA_NOTIFICATION_INTERVAL = 2000;
    public static final int DEFAULT_SUMMARY_DATA_GATHER_INTERVAL = 500;
    public static final String NAME = "managementContext";
    public static final String SESSION_MANAGEMENT_THRESHOLD_PROP = "session.management.threshold";
    public static final String MAX_MANAGEMENT_SESSIONS_PROP = "max.management.sessions";
    public static final ManagementFilterStrategy PASS_THRU_FILTER_STRATEGY = new PassThruManagementFilterStrategy();
    public static final ManagementFilterStrategy SERVICE_ONLY_FILTER_STRATEGY = new ServiceOnlyManagementFilterStrategy();
    public static final ManagementFilterStrategy FULL_FILTER_STRATEGY = new FullManagementFilterStrategy();
    public static final ManagementGatewayStrategy COLLECT_ONLY_GATEWAY_STRATEGY = new CollectOnlyManagementGatewayStrategy();
    public static final ManagementGatewayStrategy FULL_GATEWAY_STRATEGY = new FullManagementGatewayStrategy();
    public static final ManagementServiceStrategy COLLECT_ONLY_SERVICE_STRATEGY = new CollectOnlyManagementServiceStrategy();
    public static final ManagementServiceStrategy FULL_SERVICE_STRATEGY = new FullManagementServiceStrategy();
    public static final ManagementSessionStrategy COLLECT_ONLY_SESSION_STRATEGY = new CollectOnlyManagementSessionStrategy();
    public static final ManagementSessionStrategy FULL_SESSION_STRATEGY = new FullManagementSessionStrategy();
    public static final ManagementSystemStrategy COLLECT_ONLY_SYSTEM_STRATEGY = new NullManagementSystemStrategy();
    public static final ManagementSystemStrategy FULL_SYSTEM_STRATEGY = new FullManagementSystemStrategy();
    private static final ManagementStrategy[] COLLECT_ONLY_STRATEGY = new ManagementStrategy[]{FULL_FILTER_STRATEGY, COLLECT_ONLY_GATEWAY_STRATEGY, COLLECT_ONLY_SERVICE_STRATEGY, COLLECT_ONLY_SESSION_STRATEGY, COLLECT_ONLY_SYSTEM_STRATEGY};
    private static final ManagementStrategy[] FULL_STRATEGY = new ManagementStrategy[]{FULL_FILTER_STRATEGY, FULL_GATEWAY_STRATEGY, FULL_SERVICE_STRATEGY, FULL_SESSION_STRATEGY, FULL_SYSTEM_STRATEGY};
    private final int FILTER_INDEX = 0;
    private final int GATEWAY_INDEX = 1;
    private final int SERVICE_INDEX = 2;
    private final int SESSION_INDEX = 3;
    private final int SYSTEM_INDEX = 4;
    private static Map<ServiceContext, Integer> serviceIndexMap = new HashMap<ServiceContext, Integer>();
    private static Integer serviceIndexCount = 1;
    private final String localGatewayHostAndPid;
    private final AtomicBoolean managementConfigured;
    private final SummaryManagementInterval gatewaySummaryDataNotificationInterval;
    private final SummaryManagementInterval serviceSummaryDataNotificationInterval;
    private final SummaryManagementInterval sessionSummaryDataNotificationInterval;
    private final SummaryManagementInterval systemSummaryDataGatherInterval;
    private final SummaryManagementInterval systemSummaryDataNotificationInterval;
    private final SummaryManagementInterval cpuListSummaryDataGatherInterval;
    private final SummaryManagementInterval cpuListSummaryDataNotificationInterval;
    private final SummaryManagementInterval nicListSummaryDataGatherInterval;
    private final SummaryManagementInterval nicListSummaryDataNotificationInterval;
    private final SummaryManagementInterval jvmSummaryDataGatherInterval;
    private final SummaryManagementInterval jvmSummaryDataNotificationInterval;
    private ManagementStrategy[] managementStrategy = COLLECT_ONLY_STRATEGY;
    private AtomicInteger managementSessionCount = new AtomicInteger(0);
    private AtomicInteger overallSessionCount = new AtomicInteger(0);
    private int managementSessionThreshold;
    private final List<ManagementServiceHandler> managementServiceHandlers;
    private final ConcurrentHashMap<ServiceContext, ManagementFilter> managementFilters = new ConcurrentHashMap();
    private final List<GatewayManagementListener> gatewayManagementListeners = new CopyOnWriteArrayList<GatewayManagementListener>();
    private final List<ServiceManagementListener> serviceManagementListeners = new CopyOnWriteArrayList<ServiceManagementListener>();
    private final List<SessionManagementListener> sessionManagementListeners = new CopyOnWriteArrayList<SessionManagementListener>();
    private List<ManagementStrategyChangeListener> managementStrategyChangeListeners = new ArrayList<ManagementStrategyChangeListener>();
    private SchedulerProvider schedulerProvider;
    private GatewayContext gatewayContext;
    private Properties configuration;
    private SystemDataProvider systemDataProvider;
    private ScheduledExecutorService managementExecutorService;
    private boolean active;
    private final ConcurrentHashMap<String, GatewayManagementBean> gatewayManagementBeans = new ConcurrentHashMap();
    private final ConcurrentHashMap<ServiceContext, ServiceManagementBean> serviceManagementBeans = new ConcurrentHashMap();
    private final ConcurrentHashMap<ServiceContext, ServiceConfigurationBean> serviceConfigBeans = new ConcurrentHashMap();
    private final ServiceManagementBeanFactory serviceManagmentBeanFactory = ServiceManagementBeanFactory.newServiceManagementBeanFactory();

    public DefaultManagementContext() {
        this.managementServiceHandlers = new ArrayList<ManagementServiceHandler>();
        this.localGatewayHostAndPid = ManagementFactory.getRuntimeMXBean().getName();
        this.managementConfigured = new AtomicBoolean(false);
        this.gatewaySummaryDataNotificationInterval = new SummaryManagementIntervalImpl(5000);
        this.serviceSummaryDataNotificationInterval = new SummaryManagementIntervalImpl(5000);
        this.sessionSummaryDataNotificationInterval = new SummaryManagementIntervalImpl(5000);
        this.systemSummaryDataGatherInterval = new SummaryManagementIntervalImpl(500);
        this.systemSummaryDataNotificationInterval = new SummaryManagementIntervalImpl(2000);
        this.nicListSummaryDataGatherInterval = new SummaryManagementIntervalImpl(500);
        this.nicListSummaryDataNotificationInterval = new SummaryManagementIntervalImpl(2000);
        this.cpuListSummaryDataGatherInterval = new SummaryManagementIntervalImpl(500);
        this.cpuListSummaryDataNotificationInterval = new SummaryManagementIntervalImpl(2000);
        this.jvmSummaryDataGatherInterval = new SummaryManagementIntervalImpl(500);
        this.jvmSummaryDataNotificationInterval = new SummaryManagementIntervalImpl(2000);
        this.systemDataProvider = SystemDataProviderFactory.createProvider();
    }

    @Resource(name="schedulerProvider")
    public void setSchedulerProvider(SchedulerProvider schedulerProvider) {
        this.schedulerProvider = schedulerProvider;
        this.managementExecutorService = schedulerProvider.getScheduler("management", true);
    }

    @Resource(name="configuration")
    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    @Override
    public SchedulerProvider getSchedulerProvider() {
        return this.schedulerProvider;
    }

    @Resource(name="gatewayContext")
    public void setGatewayContext(GatewayContext gatewayContext) {
        this.gatewayContext = gatewayContext;
    }

    @Override
    public ClusterContext getCluster() {
        if (this.gatewayContext != null) {
            return this.gatewayContext.getCluster();
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public SystemDataProvider getSystemDataProvider() {
        return this.systemDataProvider;
    }

    @Override
    public int getManagementSessionCount() {
        return this.managementSessionCount.get();
    }

    @Override
    public void incrementManagementSessionCount() {
        this.adjustStrategies(this.managementSessionCount.incrementAndGet(), this.overallSessionCount.incrementAndGet());
    }

    @Override
    public void decrementManagementSessionCount() {
        this.adjustStrategies(this.managementSessionCount.decrementAndGet(), this.overallSessionCount.decrementAndGet());
    }

    @Override
    public void setManagementSessionThreshold(int managementSessionThreshold) {
        this.managementSessionThreshold = managementSessionThreshold;
    }

    @Override
    public int getSessionManagementThreshold() {
        return this.managementSessionThreshold;
    }

    @Override
    public int getOverallSessionCount() {
        return this.overallSessionCount.get();
    }

    @Override
    public void incrementOverallSessionCount() {
        this.adjustStrategies(this.managementSessionCount.get(), this.overallSessionCount.incrementAndGet());
    }

    @Override
    public void decrementOverallSessionCount() {
        this.adjustStrategies(this.managementSessionCount.get(), this.overallSessionCount.decrementAndGet());
    }

    @Override
    public List<GatewayManagementListener> getGatewayManagementListeners() {
        return this.gatewayManagementListeners;
    }

    @Override
    public void addGatewayManagementListener(GatewayManagementListener listener) {
        this.gatewayManagementListeners.add(listener);
    }

    @Override
    public void removeGatewayManagementListener(GatewayManagementListener listener) {
        this.gatewayManagementListeners.remove(listener);
    }

    @Override
    public List<ServiceManagementListener> getServiceManagementListeners() {
        return this.serviceManagementListeners;
    }

    @Override
    public void addServiceManagementListener(ServiceManagementListener listener) {
        this.serviceManagementListeners.add(listener);
    }

    @Override
    public void removeServiceManagementListener(ServiceManagementListener listener) {
        this.serviceManagementListeners.remove(listener);
    }

    @Override
    public List<SessionManagementListener> getSessionManagementListeners() {
        return this.sessionManagementListeners;
    }

    @Override
    public void addSessionManagementListener(SessionManagementListener listener) {
        this.sessionManagementListeners.add(listener);
    }

    @Override
    public void removeSessionManagementListener(SessionManagementListener listener) {
        this.sessionManagementListeners.remove(listener);
    }

    @Override
    public List<ManagementStrategyChangeListener> getManagementStrategyChangeListeners() {
        return this.managementStrategyChangeListeners;
    }

    @Override
    public void addManagementStrategyChangeListener(ManagementStrategyChangeListener listener) {
        this.managementStrategyChangeListeners.add(listener);
    }

    @Override
    public void removeManagementStrategyListener(ManagementStrategyChangeListener listener) {
        this.managementStrategyChangeListeners.remove(listener);
    }

    private void adjustStrategies(long managementSessionCount, long overallSessionCount) {
        ManagementStrategy[] newManagementStrategy = overallSessionCount > (long)this.managementSessionThreshold || managementSessionCount == 0L ? COLLECT_ONLY_STRATEGY : FULL_STRATEGY;
        if (newManagementStrategy != this.managementStrategy) {
            this.managementStrategy = newManagementStrategy;
            for (ManagementStrategyChangeListener listener : this.managementStrategyChangeListeners) {
                listener.managementStrategyChanged();
            }
        }
    }

    @Override
    public List<ManagementServiceHandler> getManagementServiceHandlers() {
        return this.managementServiceHandlers;
    }

    @Override
    public void addManagementServiceHandler(ManagementServiceHandler managementServiceHandler) {
        if (!this.managementServiceHandlers.contains(managementServiceHandler)) {
            this.managementServiceHandlers.add(managementServiceHandler);
            managementServiceHandler.addGatewayManagementBean(this.getLocalGatewayManagementBean());
        }
    }

    @Override
    public void removeManagementServiceHandler(ManagementServiceHandler managementServiceHandler) {
        this.managementServiceHandlers.remove(managementServiceHandler);
    }

    @Override
    public void runManagementTask(Runnable r) {
        this.managementExecutorService.execute(r);
    }

    public static synchronized int getNextServiceIndex(ServiceContext serviceContext) {
        Integer index = serviceIndexMap.get(serviceContext);
        if (index == null) {
            serviceIndexMap.put(serviceContext, serviceIndexCount);
            index = serviceIndexCount;
            Integer n = serviceIndexCount;
            Integer n2 = serviceIndexCount = Integer.valueOf(serviceIndexCount + 1);
        }
        return index;
    }

    private GatewayManagementBean getLocalGatewayManagementBean() {
        GatewayManagementBean gatewayManagementBean = this.getGatewayManagementBean(this.localGatewayHostAndPid);
        if (gatewayManagementBean == null) {
            throw new RuntimeException("GatewayManagementBean has not been created, dependency injection failed.");
        }
        return gatewayManagementBean;
    }

    private GatewayManagementBean getGatewayManagementBean(String hostAndPid) {
        return this.gatewayManagementBeans.get(hostAndPid);
    }

    private ClusterConfigurationBean addClusterConfigurationBean(ClusterContext clusterContext, GatewayManagementBean gatewayBean) {
        ClusterConfigurationBeanImpl clusterConfigBean = new ClusterConfigurationBeanImpl(clusterContext, gatewayBean);
        gatewayBean.setClusterContext(clusterContext);
        if (gatewayBean instanceof GatewayManagementBeanImpl) {
            clusterContext.getCollectionsFactory().addEntryListener((EntryListener)((GatewayManagementBeanImpl)gatewayBean), "managementServiceMap");
        }
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addClusterConfigurationBean(clusterConfigBean);
        }
        return clusterConfigBean;
    }

    private SecurityConfigurationBean addSecurityConfigurationBean(SecurityContext securityContext, GatewayManagementBean gatewayBean) {
        SecurityConfigurationBeanImpl securityBean = new SecurityConfigurationBeanImpl(securityContext, gatewayBean);
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addSecurityConfigurationBean(securityBean);
        }
        return securityBean;
    }

    private RealmConfigurationBean addRealmConfigurationBean(RealmContext realm, GatewayManagementBean gatewayBean) {
        RealmConfigurationBeanImpl realmBean = new RealmConfigurationBeanImpl(realm, gatewayBean);
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addRealmConfigurationBean(realmBean);
        }
        return realmBean;
    }

    private ServiceConfigurationBean addServiceConfigurationBean(ServiceContext service, GatewayManagementBean gatewayBean) {
        ServiceConfigurationBeanImpl serviceConfigurationBean = new ServiceConfigurationBeanImpl(service, gatewayBean);
        ServiceConfigurationBean tmpServiceConfigBean = this.serviceConfigBeans.putIfAbsent(service, serviceConfigurationBean);
        if (tmpServiceConfigBean != null) {
            return tmpServiceConfigBean;
        }
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addServiceConfigurationBean(serviceConfigurationBean);
        }
        return serviceConfigurationBean;
    }

    private void addVersionInfo(GatewayManagementBean gatewayBean) {
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addVersionInfo(gatewayBean);
        }
    }

    private void addSystemInfo(GatewayManagementBean gatewayBean) {
        HostManagementBeanImpl systemManagementBean = new HostManagementBeanImpl(gatewayBean, InternalSystemProperty.MANAGEMENT_SUMMARY_DATA_LIMIT.getIntProperty(this.configuration));
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addSystemManagementBean(systemManagementBean);
        }
        systemManagementBean.managementStrategyChanged();
    }

    private void addCpuListInfo(GatewayManagementBean gatewayBean) {
        CpuListManagementBeanImpl cpuListManagementBean = new CpuListManagementBeanImpl(gatewayBean, InternalSystemProperty.MANAGEMENT_SUMMARY_DATA_LIMIT.getIntProperty(this.configuration));
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addCpuListManagementBean(cpuListManagementBean);
        }
        CpuManagementBean[] cpuManagementBeans = cpuListManagementBean.getCpuManagementBeans();
        String hostAndPid = gatewayBean.getHostAndPid();
        for (int i = 0; i < cpuManagementBeans.length; ++i) {
            for (ManagementServiceHandler handler : this.managementServiceHandlers) {
                handler.addCpuManagementBean(cpuManagementBeans[i], hostAndPid);
            }
        }
        cpuListManagementBean.managementStrategyChanged();
    }

    private void addNicListInfo(GatewayManagementBean gatewayBean) {
        NicListManagementBeanImpl nicListManagementBean = new NicListManagementBeanImpl(gatewayBean, InternalSystemProperty.MANAGEMENT_SUMMARY_DATA_LIMIT.getIntProperty(this.configuration));
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addNicListManagementBean(nicListManagementBean);
        }
        NicManagementBean[] nicManagementBeans = nicListManagementBean.getNicManagementBeans();
        String hostAndPid = gatewayBean.getHostAndPid();
        for (int i = 0; i < nicManagementBeans.length; ++i) {
            for (ManagementServiceHandler handler : this.managementServiceHandlers) {
                handler.addNicManagementBean(nicManagementBeans[i], hostAndPid);
            }
        }
        nicListManagementBean.managementStrategyChanged();
    }

    private void addJvmInfo(GatewayManagementBean gatewayBean) {
        JvmManagementBeanImpl jvmManagementBean = new JvmManagementBeanImpl(gatewayBean, InternalSystemProperty.MANAGEMENT_SUMMARY_DATA_LIMIT.getIntProperty(this.configuration));
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addJvmManagementBean(jvmManagementBean);
        }
        jvmManagementBean.managementStrategyChanged();
    }

    private ServiceDefaultsConfigurationBean addServiceDefaultsConfigurationBean(ServiceDefaultsContext serviceDefaultsContext, GatewayManagementBean gatewayBean) {
        ServiceDefaultsConfigurationBeanImpl serviceDefaultsConfigurationBean = new ServiceDefaultsConfigurationBeanImpl(serviceDefaultsContext, gatewayBean);
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addServiceDefaultsConfigurationBean(serviceDefaultsConfigurationBean);
        }
        return serviceDefaultsConfigurationBean;
    }

    private ManagementFilter addManagementFilter(ServiceContext serviceContext, ServiceManagementBean serviceBean) {
        ManagementFilter managementFilter = new ManagementFilter(serviceBean);
        this.managementFilters.put(serviceContext, managementFilter);
        return managementFilter;
    }

    @Override
    public ManagementFilter getManagementFilter(ServiceContext serviceContext) {
        ManagementFilter managementFilter = this.managementFilters.get(serviceContext);
        if (managementFilter == null) {
            ServiceManagementBean serviceBean = this.serviceManagementBeans.get(serviceContext);
            managementFilter = this.addManagementFilter(serviceContext, serviceBean);
        }
        return managementFilter;
    }

    @Override
    public ManagementFilterStrategy getManagementFilterStrategy() {
        return (ManagementFilterStrategy)this.managementStrategy[0];
    }

    @Override
    public ManagementGatewayStrategy getManagementGatewayStrategy() {
        return (ManagementGatewayStrategy)this.managementStrategy[1];
    }

    @Override
    public ManagementServiceStrategy getManagementServiceStrategy() {
        return (ManagementServiceStrategy)this.managementStrategy[2];
    }

    @Override
    public ManagementSessionStrategy getManagementSessionStrategy() {
        return (ManagementSessionStrategy)this.managementStrategy[3];
    }

    @Override
    public ManagementSystemStrategy getManagementSystemStrategy() {
        return (ManagementSystemStrategy)this.managementStrategy[4];
    }

    @Override
    public void addServiceManagementBean(ServiceContext serviceContext) {
        GatewayManagementBean gatewayManagementBean = this.getLocalGatewayManagementBean();
        ServiceManagementBean serviceManagementBean = this.serviceManagmentBeanFactory.newServiceManagementBean(serviceContext.getServiceType(), gatewayManagementBean, serviceContext);
        ServiceManagementBean tempBean = this.serviceManagementBeans.putIfAbsent(serviceContext, serviceManagementBean);
        if (tempBean == null) {
            for (ManagementServiceHandler handler : this.managementServiceHandlers) {
                handler.addServiceManagementBean(serviceManagementBean);
            }
        }
    }

    @Override
    public SessionManagementBean addSessionManagementBean(ServiceManagementBean serviceManagementBean, IoSessionEx session) {
        SessionManagementBeanImpl sessionManagementBean = new SessionManagementBeanImpl(serviceManagementBean, session);
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.addSessionManagementBean(sessionManagementBean);
        }
        return sessionManagementBean;
    }

    @Override
    public void removeSessionManagementBean(SessionManagementBean sessionBean) {
        for (ManagementServiceHandler handler : this.managementServiceHandlers) {
            handler.removeSessionManagementBean(sessionBean);
        }
    }

    @Override
    public void updateManagementContext(SecurityContext securityContext) {
        if (this.managementConfigured.compareAndSet(false, true)) {
            ServiceDefaultsContext serviceDefaults;
            GatewayManagementBean gatewayBean = this.getLocalGatewayManagementBean();
            Collection services = this.gatewayContext.getServices();
            if (services != null && !services.isEmpty()) {
                for (ServiceContext service : services) {
                    this.addServiceConfigurationBean(service, gatewayBean);
                }
            }
            this.addVersionInfo(gatewayBean);
            this.addSystemInfo(gatewayBean);
            this.addCpuListInfo(gatewayBean);
            this.addNicListInfo(gatewayBean);
            this.addJvmInfo(gatewayBean);
            ClusterContext clusterContext = this.gatewayContext.getCluster();
            if (clusterContext != null) {
                this.addClusterConfigurationBean(clusterContext, gatewayBean);
            }
            this.addSecurityConfigurationBean(securityContext, gatewayBean);
            Collection realms = this.gatewayContext.getRealms();
            if (realms != null && !realms.isEmpty()) {
                for (RealmContext realm : realms) {
                    this.addRealmConfigurationBean(realm, gatewayBean);
                }
            }
            if ((serviceDefaults = this.gatewayContext.getServiceDefaults()) != null) {
                this.addServiceDefaultsConfigurationBean(serviceDefaults, gatewayBean);
            }
        }
    }

    @Override
    public SummaryManagementInterval getGatewaySummaryDataNotificationInterval() {
        return this.gatewaySummaryDataNotificationInterval;
    }

    @Override
    public SummaryManagementInterval getServiceSummaryDataNotificationInterval() {
        return this.serviceSummaryDataNotificationInterval;
    }

    @Override
    public SummaryManagementInterval getSessionSummaryDataNotificationInterval() {
        return this.sessionSummaryDataNotificationInterval;
    }

    @Override
    public SummaryManagementInterval getSystemSummaryDataGatherInterval() {
        return this.systemSummaryDataGatherInterval;
    }

    @Override
    public SummaryManagementInterval getSystemSummaryDataNotificationInterval() {
        return this.systemSummaryDataNotificationInterval;
    }

    @Override
    public SummaryManagementInterval getCpuListSummaryDataGatherInterval() {
        return this.cpuListSummaryDataGatherInterval;
    }

    @Override
    public SummaryManagementInterval getCpuListSummaryDataNotificationInterval() {
        return this.cpuListSummaryDataNotificationInterval;
    }

    @Override
    public SummaryManagementInterval getNicListSummaryDataGatherInterval() {
        return this.nicListSummaryDataGatherInterval;
    }

    @Override
    public SummaryManagementInterval getNicListSummaryDataNotificationInterval() {
        return this.nicListSummaryDataNotificationInterval;
    }

    @Override
    public SummaryManagementInterval getJvmSummaryDataGatherInterval() {
        return this.jvmSummaryDataGatherInterval;
    }

    @Override
    public SummaryManagementInterval getJvmSummaryDataNotificationInterval() {
        return this.jvmSummaryDataNotificationInterval;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public void createGatewayManagementBean() {
        GatewayManagementBeanImpl gatewayManagementBean = new GatewayManagementBeanImpl((ManagementContext)this, this.gatewayContext, this.localGatewayHostAndPid);
        this.gatewayManagementBeans.put(this.localGatewayHostAndPid, gatewayManagementBean);
    }

    private final class SummaryManagementIntervalImpl
    implements SummaryManagementInterval {
        private int interval;

        private SummaryManagementIntervalImpl(int interval) {
            this.interval = interval;
        }

        @Override
        public int getInterval() {
            return this.interval;
        }

        @Override
        public void setInterval(int interval) {
            this.interval = interval;
        }
    }
}

