/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.system;

import org.hyperic.sigar.SigarException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.system.AbstractSystemManagementBean;
import org.kaazing.gateway.management.system.NicListManagementBean;
import org.kaazing.gateway.management.system.NicManagementBean;
import org.kaazing.gateway.management.system.NicManagementBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NicListManagementBeanImpl
extends AbstractSystemManagementBean
implements NicListManagementBean {
    private final GatewayManagementBean gatewayManagementBean;
    private String[] netInterfaceNames;
    private NicManagementBean[] nicManagementBeans;
    private static final Logger logger = LoggerFactory.getLogger(NicListManagementBeanImpl.class);

    public NicListManagementBeanImpl(GatewayManagementBean gatewayManagementBean) {
        super(gatewayManagementBean.getManagementContext(), gatewayManagementBean.getManagementContext().getSystemSummaryDataNotificationInterval(), NicManagementBean.SUMMARY_DATA_FIELD_LIST, gatewayManagementBean.getManagementContext().getNicListSummaryDataGatherInterval(), "NIC list stats", "SNMPNicListSummaryData");
        this.gatewayManagementBean = gatewayManagementBean;
        this.netInterfaceNames = this.managementContext.getSystemDataProvider().getNetInterfaceNames();
        this.nicManagementBeans = new NicManagementBean[this.netInterfaceNames.length];
        for (int i = 0; i < this.netInterfaceNames.length; ++i) {
            this.nicManagementBeans[i] = new NicManagementBeanImpl(i, this.netInterfaceNames[i]);
        }
    }

    @Override
    public GatewayManagementBean getGatewayManagementBean() {
        return this.gatewayManagementBean;
    }

    @Override
    public NicManagementBean[] getNicManagementBeans() {
        return this.nicManagementBeans;
    }

    @Override
    public String getNetInterfaceNames() {
        JSONArray jsonArray = null;
        try {
            jsonArray = new JSONArray((Object)this.netInterfaceNames);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonArray.toString();
    }

    @Override
    public void doGatherStats(JSONObject jsonObj, long readTime) throws SigarException, JSONException {
        JSONArray nicData = new JSONArray();
        for (int i = 0; i < this.netInterfaceNames.length; ++i) {
            String nicName = null;
            nicName = this.netInterfaceNames[i];
            Long[] netInterfaceStats = this.managementContext.getSystemDataProvider().getNetInterfaceStats(nicName);
            NicManagementBean nicBean = this.nicManagementBeans[i];
            nicBean.update(netInterfaceStats, readTime);
            nicData.put((Object)nicBean.getSummaryDataValues());
        }
        jsonObj.put("nicData", (Object)nicData);
    }
}

