/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.mib;

import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.snmp.SummaryDataIntervalMO;
import org.kaazing.gateway.management.snmp.mib.MIBConstants;
import org.kaazing.gateway.management.system.NicListManagementBean;
import org.kaazing.gateway.management.system.NicManagementBean;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.AgentCapabilityList;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class NicManagementMIB
implements MOGroup,
CounterListener,
AgentCapabilityList {
    private static final int NET_INTERFACE_NAMES_OPER = 1;
    private static final int SUMMARY_DATA_FIELDS_OPER = 2;
    private static final int SUMMARY_DATA_OPER = 3;
    private final ManagementContext managementContext;
    private DefaultMOTable sysOREntry;
    private DefaultMOMutableTableModel sysOREntryModel;
    private MOTableSubIndex[] entryIndexes;
    private MOTableIndex entryIndex;
    private MOTable nicEntry;
    private MOTableModel nicEntryModel;
    private SystemString netInterfaceNames;
    private SystemString summaryDataFields;
    private SystemString summaryData;
    private MOScalar summaryDataNotificationInterval;
    private MOScalar summaryDataGatherInterval;
    private NicListManagementBean bean;

    public NicManagementMIB(ManagementContext managementContext, MOFactory factory) {
        this.managementContext = managementContext;
        this.createMO(factory);
    }

    private void createMO(MOFactory moFactory) {
        OID nicEntryIndexOID = ((OID)MIBConstants.oidNicListEntry.clone()).append(1);
        this.entryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(nicEntryIndexOID, 2, 1, 1)};
        this.entryIndex = moFactory.createIndex(this.entryIndexes, true);
        MOColumn[] entryColumns = new MOColumn[]{new MOMutableColumn(1, 2, moFactory.createAccess(1)), new MOMutableColumn(2, 70, moFactory.createAccess(1)), new MOMutableColumn(3, 4, moFactory.createAccess(1)), new MOMutableColumn(4, 70, moFactory.createAccess(1)), new MOMutableColumn(5, 70, moFactory.createAccess(1)), new MOMutableColumn(6, 70, moFactory.createAccess(1)), new MOMutableColumn(7, 70, moFactory.createAccess(1)), new MOMutableColumn(8, 70, moFactory.createAccess(1)), new MOMutableColumn(9, 70, moFactory.createAccess(1)), new MOMutableColumn(10, 70, moFactory.createAccess(1)), new MOMutableColumn(11, 70, moFactory.createAccess(1)), new MOMutableColumn(12, 4, moFactory.createAccess(1))};
        this.nicEntryModel = new NicManagementTableModel();
        this.nicEntry = moFactory.createTable(MIBConstants.oidNicListEntry, this.entryIndex, entryColumns, this.nicEntryModel);
        this.netInterfaceNames = new SystemString(MIBConstants.oidNicListNetInterfaceNames, moFactory.createAccess(9), (Variable)new OctetString(), 1);
        this.summaryDataFields = new SystemString(MIBConstants.oidNicListSummaryDataFields, moFactory.createAccess(9), (Variable)new OctetString(), 2);
        this.summaryData = new SystemString(MIBConstants.oidNicListSummaryData, moFactory.createAccess(9), (Variable)new OctetString(), 3);
        this.summaryDataNotificationInterval = new SummaryDataIntervalMO(moFactory, this.managementContext.getNicListSummaryDataNotificationInterval(), MIBConstants.oidNicListSummaryDataNotificationInterval);
        this.summaryDataGatherInterval = new SummaryDataIntervalMO(moFactory, this.managementContext.getNicListSummaryDataNotificationInterval(), MIBConstants.oidNicListSummaryDataGatherInterval);
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register((ManagedObject)this.nicEntry, context);
        server.register((ManagedObject)this.netInterfaceNames, context);
        server.register((ManagedObject)this.summaryDataFields, context);
        server.register((ManagedObject)this.summaryData, context);
        server.register((ManagedObject)this.summaryDataNotificationInterval, context);
        server.register((ManagedObject)this.summaryDataGatherInterval, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister((ManagedObject)this.nicEntry, context);
        server.unregister((ManagedObject)this.netInterfaceNames, context);
        server.unregister((ManagedObject)this.summaryDataFields, context);
        server.unregister((ManagedObject)this.summaryData, context);
        server.unregister((ManagedObject)this.summaryDataNotificationInterval, context);
        server.unregister((ManagedObject)this.summaryDataGatherInterval, context);
    }

    public void addNicListManagementBean(NicListManagementBean nicListManagementBean) {
        this.bean = nicListManagementBean;
    }

    public void incrementCounter(CounterEvent event) {
    }

    public OID addSysOREntry(OID sysORID, OctetString sysORDescr) {
        OID index = new OID(new int[]{this.sysOREntryModel.getRowCount() + 1});
        Variable[] values = new Variable[this.sysOREntry.getColumnCount()];
        int n = 0;
        values[n++] = sysORID;
        values[n++] = sysORDescr;
        DefaultMOTableRow row = new DefaultMOTableRow(index, values);
        this.sysOREntry.addRow((MOTableRow)row);
        return index;
    }

    public MOTableRow removeSysOREntry(OID index) {
        return this.sysOREntry.removeRow(index);
    }

    public OID addNicManagementBean(NicManagementBean bean) {
        OID cpuIndexOID = new OID(new int[]{bean.getId()});
        this.nicEntry.addRow((MOTableRow)new NicEntryRow(cpuIndexOID, bean));
        return cpuIndexOID;
    }

    public void removeNicManagementBean(OID oid) {
        this.nicEntry.removeRow(oid);
    }

    class SystemString
    extends MOScalar {
        private int operation;

        SystemString(OID id, MOAccess access, Variable value, int operation) {
            super(id, access, value);
            this.operation = operation;
        }

        public Variable getValue() {
            String value = "";
            switch (this.operation) {
                case 1: {
                    value = NicManagementMIB.this.bean.getNetInterfaceNames();
                    break;
                }
                case 2: {
                    value = NicManagementMIB.this.bean.getSummaryDataFields();
                    break;
                }
                case 3: {
                    value = NicManagementMIB.this.bean.getSummaryData();
                    break;
                }
                default: {
                    throw new RuntimeException("SystemString incorrectly configured with unsupported operation: " + this.operation);
                }
            }
            OctetString val = (OctetString)Utils.stringToVariable(value);
            return val;
        }
    }

    private final class NicEntryRow
    extends DefaultMOMutableRow2PC {
        private NicManagementBean bean;

        private NicEntryRow(OID index, NicManagementBean bean) {
            super(index, null);
            this.bean = bean;
        }

        public int size() {
            return 12;
        }

        public Variable getValue(int column) {
            Number scalarValue = null;
            try {
                switch (column) {
                    case 0: {
                        return new Integer32(this.getIndex().last());
                    }
                    case 1: {
                        scalarValue = this.bean.getId();
                        break;
                    }
                    case 2: {
                        return Utils.stringToVariable(this.bean.getName());
                    }
                    case 3: {
                        scalarValue = this.bean.getRxBytes();
                        break;
                    }
                    case 4: {
                        scalarValue = this.bean.getRxBytesPerSecond();
                        break;
                    }
                    case 5: {
                        scalarValue = this.bean.getRxDropped();
                        break;
                    }
                    case 6: {
                        scalarValue = this.bean.getRxErrors();
                        break;
                    }
                    case 7: {
                        scalarValue = this.bean.getTxBytes();
                        break;
                    }
                    case 8: {
                        scalarValue = this.bean.getTxBytesPerSecond();
                        break;
                    }
                    case 9: {
                        scalarValue = this.bean.getTxDropped();
                        break;
                    }
                    case 10: {
                        scalarValue = this.bean.getTxErrors();
                        break;
                    }
                    case 11: {
                        return Utils.stringToVariable(this.bean.getSummaryData());
                    }
                    default: {
                        return super.getValue(column);
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (scalarValue == null) {
                return new Null();
            }
            long counterValue = 0L;
            counterValue = scalarValue instanceof Double ? (long)((Double)scalarValue * 1000.0) : (scalarValue instanceof Float ? (long)(((Float)scalarValue).floatValue() * 1000.0f) : ((Number)scalarValue).longValue());
            return new Counter64(counterValue);
        }

        public void commit(SubRequest subRequest, MOTableRow changeSet, int column) {
            this.setValue(column, (Variable)subRequest.getVariableBinding().getVariable().clone());
            subRequest.completed();
        }
    }

    private class NicManagementTableModel
    extends DefaultMOMutableTableModel {
        private NicManagementTableModel() {
        }
    }
}

