/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.session;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kaazing.gateway.management.AbstractManagementBean;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.management.session.SessionManagementBean;
import org.kaazing.gateway.management.session.SessionManagementListener;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManagementBeanImpl
extends AbstractManagementBean
implements SessionManagementBean {
    private static final long CLOSE_TIMEOUT_MS = 100L;
    private static final Logger logger = LoggerFactory.getLogger(SessionManagementBeanImpl.class);
    private final ServiceManagementBean serviceManagementBean;
    private final IoSessionEx session;
    private final String sessionTypeName;
    private final String sessionDirection;
    private Map<String, String> userPrincipals;
    private boolean notificationsEnabled;
    private long exceptionCount;

    public SessionManagementBeanImpl(ServiceManagementBean serviceManagementBean, IoSessionEx session) {
        super(serviceManagementBean.getGatewayManagementBean().getManagementContext(), serviceManagementBean.getGatewayManagementBean().getManagementContext().getSessionSummaryDataNotificationInterval(), SUMMARY_DATA_FIELD_LIST);
        this.serviceManagementBean = serviceManagementBean;
        this.session = session;
        this.sessionTypeName = Utils.getSessionTypeName((ResourceAddress)BridgeSession.LOCAL_ADDRESS.get((IoSession)session));
        this.sessionDirection = Utils.getSessionDirection(session);
    }

    @Override
    public ServiceManagementBean getServiceManagementBean() {
        return this.serviceManagementBean;
    }

    private List<SessionManagementListener> getManagementListeners() {
        return this.managementContext.getSessionManagementListeners();
    }

    @Override
    public IoSessionEx getSession() {
        return this.session;
    }

    @Override
    public Map<String, String> getUserPrincipalMap() {
        return this.userPrincipals;
    }

    @Override
    public void setUserPrincipals(Map<String, String> userPrincipals) {
        this.userPrincipals = userPrincipals;
        this.serviceManagementBean.addUserPrincipals(this.session, userPrincipals);
    }

    @Override
    public void close() {
        CloseFuture future = this.session.close(false);
        try {
            future.await(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void closeImmediately() {
        CloseFuture future = this.session.close(true);
        try {
            future.await(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public long getId() {
        return this.session.getId();
    }

    @Override
    public long getReadBytes() {
        return this.session.getReadBytes();
    }

    @Override
    public double getReadBytesThroughput() {
        this.session.updateThroughput(System.currentTimeMillis(), false);
        return this.session.getReadBytesThroughput();
    }

    @Override
    public long getWrittenBytes() {
        return this.session.getWrittenBytes();
    }

    @Override
    public double getWrittenBytesThroughput() {
        this.session.updateThroughput(System.currentTimeMillis(), false);
        return this.session.getWrittenBytesThroughput();
    }

    @Override
    public String getUserPrincipals() {
        if (this.userPrincipals == null) {
            return null;
        }
        JSONObject jsonObj = new JSONObject(this.userPrincipals);
        return jsonObj.toString();
    }

    @Override
    public String getSummaryData() {
        long start = System.nanoTime();
        JSONArray jsonArray = null;
        try {
            Object[] vals = new Object[SUMMARY_DATA_FIELD_LIST.length];
            vals[0] = this.getReadBytes();
            vals[1] = this.getReadBytesThroughput();
            vals[2] = this.getWrittenBytes();
            vals[3] = this.getWrittenBytesThroughput();
            jsonArray = new JSONArray((Object)vals);
        }
        catch (JSONException ex) {
            // empty catch block
        }
        String val = jsonArray.toString();
        long stop = System.nanoTime();
        return val;
    }

    @Override
    public void enableNotifications(boolean notificationsEnabled) {
        this.notificationsEnabled = notificationsEnabled;
    }

    @Override
    public boolean areNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    @Override
    public void incrementExceptionCount() {
        ++this.exceptionCount;
    }

    @Override
    public long getCreateTime() {
        return this.session.getCreationTime();
    }

    @Override
    public String getRemoteAddress() {
        String remoteAddress = this.serviceManagementBean.getSessionRemoteAddress(this.session);
        return remoteAddress;
    }

    @Override
    public String getSessionTypeName() {
        return this.sessionTypeName;
    }

    @Override
    public String getSessionDirection() {
        return this.sessionDirection;
    }

    @Override
    public void doSessionCreated() throws Exception {
        Set<String> userPrincipalClasses = this.serviceManagementBean.getUserPrincipalClasses();
        if (userPrincipalClasses != null && !userPrincipalClasses.isEmpty()) {
            HashMap<String, String> userPrincipals = new HashMap<String, String>();
            Subject subject = this.session.getSubject();
            if (subject != null) {
                Set<Principal> principals = subject.getPrincipals();
                for (Principal principal : principals) {
                    String principalName = principal.getName();
                    String principalClass = principal.getClass().getName();
                    if (!userPrincipalClasses.contains(principalClass)) continue;
                    userPrincipals.put(principalName, principalClass);
                }
                this.setUserPrincipals(userPrincipals);
            }
        }
    }

    @Override
    public void doSessionCreatedListeners() {
        this.runManagementTask(new Runnable(){

            @Override
            public void run() {
                try {
                    for (SessionManagementListener listener : SessionManagementBeanImpl.this.getManagementListeners()) {
                        listener.doSessionCreated(SessionManagementBeanImpl.this);
                    }
                }
                catch (Exception ex) {
                    logger.warn("Error during doSessionCreated session listener notifications:", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void doSessionClosed() throws Exception {
        this.serviceManagementBean.removeUserPrincipals(this.session);
    }

    @Override
    public void doSessionClosedListeners() {
        this.runManagementTask(new Runnable(){

            @Override
            public void run() {
                try {
                    for (SessionManagementListener listener : SessionManagementBeanImpl.this.getManagementListeners()) {
                        listener.doSessionClosed(SessionManagementBeanImpl.this);
                    }
                }
                catch (Exception ex) {
                    logger.warn("Error during doSessionClosed session listener notifications:", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void doMessageReceived(Object message) throws Exception {
    }

    @Override
    public void doMessageReceivedListeners(final Object message) {
        this.runManagementTask(new Runnable(){

            @Override
            public void run() {
                try {
                    List sessionListeners = SessionManagementBeanImpl.this.getManagementListeners();
                    for (SessionManagementListener listener : sessionListeners) {
                        listener.doMessageReceived(SessionManagementBeanImpl.this, message);
                    }
                    SessionManagementBeanImpl.this.markChanged();
                }
                catch (Exception ex) {
                    logger.warn("Error during doMessageReceived session listener notifications:", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void doFilterWrite(WriteRequest writeRequest) throws Exception {
    }

    @Override
    public void doFilterWriteListeners(WriteRequest writeRequest) {
        final Object message = writeRequest.getMessage();
        WriteRequest originalRequest = writeRequest.getOriginalRequest();
        final Object originalMessage = originalRequest != null ? originalRequest.getMessage() : null;
        this.runManagementTask(new Runnable(){

            @Override
            public void run() {
                try {
                    List sessionListeners = SessionManagementBeanImpl.this.getManagementListeners();
                    for (SessionManagementListener listener : sessionListeners) {
                        listener.doFilterWrite(SessionManagementBeanImpl.this, message, originalMessage);
                    }
                    SessionManagementBeanImpl.this.markChanged();
                }
                catch (Exception ex) {
                    logger.warn("Error during doFilterWrite session listener notifications:", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void doExceptionCaught(Throwable cause) throws Exception {
        this.incrementExceptionCount();
    }

    @Override
    public void doExceptionCaughtListeners(final Throwable cause) {
        this.runManagementTask(new Runnable(){

            @Override
            public void run() {
                try {
                    List sessionListeners = SessionManagementBeanImpl.this.getManagementListeners();
                    for (SessionManagementListener listener : sessionListeners) {
                        listener.doExceptionCaught(SessionManagementBeanImpl.this, cause);
                    }
                    SessionManagementBeanImpl.this.markChanged();
                }
                catch (Exception ex) {
                    logger.warn("Error during doExceptionCaught session listener notifications:", (Throwable)ex);
                }
            }
        });
    }
}

