/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.kaazing.gateway.management.jmx.JmxManagementServiceHandler;
import org.kaazing.gateway.management.jmx.ServiceMXBean;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.transport.TypedAttributeKey;

public class ServiceMXBeanImpl
implements ServiceMXBean {
    private ServiceManagementBean serviceManagementBean;
    private JmxManagementServiceHandler managementServiceHandler;
    private final ObjectName objectName;
    public static final TypedAttributeKey<Boolean> SESSION_CREATED_FLAG_KEY = new TypedAttributeKey(ServiceMXBeanImpl.class, "sessionCreatedFlag");

    public ServiceMXBeanImpl(JmxManagementServiceHandler managementServiceHandler, ObjectName objectName, ServiceManagementBean serviceManagementBean) {
        this.managementServiceHandler = managementServiceHandler;
        this.objectName = objectName;
        this.serviceManagementBean = serviceManagementBean;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public int getIndex() {
        return this.serviceManagementBean.getId();
    }

    @Override
    public long getNumberOfCumulativeSessions() {
        return this.serviceManagementBean.getCumulativeSessionCount();
    }

    @Override
    public long getNumberOfCumulativeNativeSessions() {
        return this.serviceManagementBean.getCumulativeNativeSessionCount();
    }

    @Override
    public long getNumberOfCumulativeEmulatedSessions() {
        return this.serviceManagementBean.getCumulativeEmulatedSessionCount();
    }

    @Override
    public long getNumberOfCurrentSessions() {
        return this.serviceManagementBean.getCurrentSessionCount();
    }

    @Override
    public long getNumberOfCurrentNativeSessions() {
        return this.serviceManagementBean.getCurrentNativeSessionCount();
    }

    @Override
    public long getNumberOfCurrentEmulatedSessions() {
        return this.serviceManagementBean.getCurrentEmulatedSessionCount();
    }

    @Override
    public long getNumberOfExceptions() {
        return this.serviceManagementBean.getExceptionCount();
    }

    @Override
    public String getLatestException() {
        return this.serviceManagementBean.getLatestException();
    }

    @Override
    public void clearCumulativeSessionsCount() {
        this.serviceManagementBean.clearCumulativeSessionsCount();
    }

    @Override
    public long getTotalBytesReceivedCount() {
        return this.serviceManagementBean.getTotalBytesReceivedCount();
    }

    @Override
    public long getTotalBytesSentCount() {
        return this.serviceManagementBean.getTotalBytesSentCount();
    }

    @Override
    public Map<String, Map<String, String>> getLoggedInSessions() {
        Map<Long, Map<String, String>> sessionPrincipalMap = this.serviceManagementBean.getLoggedInSessions();
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry<Long, Map<String, String>> entry : sessionPrincipalMap.entrySet()) {
            long sessionId = entry.getKey();
            Map<String, String> userPrincipals = entry.getValue();
            ObjectName sessionMBeanName = this.managementServiceHandler.getSessionMXBean(sessionId).getObjectName();
            result.put(sessionMBeanName.toString(), userPrincipals);
        }
        return result;
    }

    @Override
    public Map<String, String> getUserPrincipals(Long sessionId) {
        Map<Long, Map<String, String>> sessionPrincipalMap = this.serviceManagementBean.getLoggedInSessions();
        if (sessionPrincipalMap != null) {
            for (Map.Entry<Long, Map<String, String>> entry : sessionPrincipalMap.entrySet()) {
                if (entry.getKey().longValue() != sessionId.longValue()) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public long getLastSuccessfulConnectTime() {
        return this.serviceManagementBean.getLastSuccessfulConnectTime();
    }

    @Override
    public long getLastFailedConnectTime() {
        return this.serviceManagementBean.getLastFailedConnectTime();
    }

    @Override
    public boolean getLastHeartbeatPingResult() {
        return this.serviceManagementBean.getLastHeartbeatPingResult();
    }

    @Override
    public long getLastHeartbeatPingTimestamp() {
        return this.serviceManagementBean.getLastHeartbeatPingTimestamp();
    }

    @Override
    public int getHeartbeatPingCount() {
        return this.serviceManagementBean.getHeartbeatPingCount();
    }

    @Override
    public int getHeartbeatPingSuccessesCount() {
        return this.serviceManagementBean.getHeartbeatPingSuccessesCount();
    }

    @Override
    public int getHeartbeatPingFailuresCount() {
        return this.serviceManagementBean.getHeartbeatPingFailuresCount();
    }

    @Override
    public boolean isServiceConnected() {
        return this.serviceManagementBean.isServiceConnected();
    }

    @Override
    public boolean isHeartbeatRunning() {
        return this.serviceManagementBean.isHeartbeatRunning();
    }

    @Override
    public void start() throws Exception {
        this.serviceManagementBean.start();
    }

    @Override
    public void stop() throws Exception {
        this.serviceManagementBean.stop();
    }

    @Override
    public void restart() throws Exception {
        this.serviceManagementBean.restart();
    }
}

