/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.mib;

import org.json.JSONArray;
import org.json.JSONException;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.snmp.SummaryDataIntervalMO;
import org.kaazing.gateway.management.snmp.mib.MIBConstants;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.AgentCapabilityList;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class GatewayManagementMIB
implements MOGroup,
CounterListener,
AgentCapabilityList {
    private final ManagementContext managementContext;
    private DefaultMOTable sysOREntry;
    private DefaultMOMutableTableModel sysOREntryModel;
    private MOTableSubIndex[] gatewayEntryIndexes;
    private MOTableIndex gatewayEntryIndex;
    private MOTable gatewayEntry;
    private MOTableModel gatewayEntryModel;
    private MOScalar summaryDataFields;
    private MOScalar summaryDataNotificationInterval;

    public GatewayManagementMIB(ManagementContext managementContext, MOFactory factory) {
        this.managementContext = managementContext;
        this.createMO(factory);
    }

    private void createMO(MOFactory moFactory) {
        OID gatewayConfigEntryIndexOID = ((OID)MIBConstants.oidGatewayEntry.clone()).append(1);
        this.gatewayEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(gatewayConfigEntryIndexOID, 2, 1, 1)};
        this.gatewayEntryIndex = moFactory.createIndex(this.gatewayEntryIndexes, true);
        MOColumn[] gatewayEntryColumns = new MOColumn[]{new MOMutableColumn(1, 2, moFactory.createAccess(1)), new MOMutableColumn(2, 70, moFactory.createAccess(1)), new MOMutableColumn(3, 70, moFactory.createAccess(1)), new MOMutableColumn(4, 70, moFactory.createAccess(1)), new MOMutableColumn(5, 70, moFactory.createAccess(1)), new MOMutableColumn(6, 70, moFactory.createAccess(1)), new MOMutableColumn(7, 70, moFactory.createAccess(1)), new MOMutableColumn(8, 4, moFactory.createAccess(1)), new MOMutableColumn(9, 4, moFactory.createAccess(1)), new MOMutableColumn(10, 4, moFactory.createAccess(1)), new MOMutableColumn(11, 4, moFactory.createAccess(1)), new MOMutableColumn(12, 4, moFactory.createAccess(1)), new MOMutableColumn(13, 4, moFactory.createAccess(1)), new MOMutableColumn(14, 2, moFactory.createAccess(11))};
        this.gatewayEntryModel = new GatewayMXBeanTableModel();
        this.gatewayEntry = moFactory.createTable(MIBConstants.oidGatewayEntry, this.gatewayEntryIndex, gatewayEntryColumns, this.gatewayEntryModel);
        try {
            JSONArray jsonArray = new JSONArray((Object)GatewayManagementBean.SUMMARY_DATA_FIELD_LIST);
            this.summaryDataFields = new MOScalar(MIBConstants.oidGatewaySummaryDataFields, moFactory.createAccess(1), (Variable)new OctetString(jsonArray.toString()));
        }
        catch (JSONException ex) {
            // empty catch block
        }
        this.summaryDataNotificationInterval = new SummaryDataIntervalMO(moFactory, this.managementContext.getGatewaySummaryDataNotificationInterval(), MIBConstants.oidGatewaySummaryDataNotificationInterval);
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register((ManagedObject)this.gatewayEntry, context);
        server.register((ManagedObject)this.summaryDataFields, context);
        server.register((ManagedObject)this.summaryDataNotificationInterval, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister((ManagedObject)this.gatewayEntry, context);
        server.unregister((ManagedObject)this.summaryDataFields, context);
        server.unregister((ManagedObject)this.summaryDataNotificationInterval, context);
    }

    public void incrementCounter(CounterEvent event) {
    }

    public OID addSysOREntry(OID sysORID, OctetString sysORDescr) {
        OID index = new OID(new int[]{this.sysOREntryModel.getRowCount() + 1});
        Variable[] values = new Variable[this.sysOREntry.getColumnCount()];
        int n = 0;
        values[n++] = sysORID;
        values[n++] = sysORDescr;
        DefaultMOTableRow row = new DefaultMOTableRow(index, values);
        this.sysOREntry.addRow((MOTableRow)row);
        return index;
    }

    public MOTableRow removeSysOREntry(OID index) {
        return this.sysOREntry.removeRow(index);
    }

    public OID addGatewayBean(GatewayManagementBean bean) {
        OID gatewayIndexOID = new OID(new int[]{bean.getId()});
        this.gatewayEntry.addRow((MOTableRow)new GatewayEntryRow(gatewayIndexOID, bean));
        return gatewayIndexOID;
    }

    public void removeGatewayBean(OID oid) {
        this.gatewayEntry.removeRow(oid);
    }

    private class GatewayEntryRow
    extends DefaultMOMutableRow2PC {
        private GatewayManagementBean bean;

        private GatewayEntryRow(OID index, GatewayManagementBean bean) {
            super(index, null);
            this.bean = bean;
        }

        public int size() {
            return 14;
        }

        public Variable getValue(int column) {
            try {
                switch (column) {
                    case 0: {
                        return new Integer32(this.getIndex().last());
                    }
                    case 1: {
                        return Utils.stringToVariable(this.bean.getHostAndPid());
                    }
                    case 2: {
                        return new Counter64(this.bean.getTotalCurrentSessions());
                    }
                    case 3: {
                        return new Counter64(this.bean.getTotalBytesReceived());
                    }
                    case 4: {
                        return new Counter64(this.bean.getTotalBytesSent());
                    }
                    case 5: {
                        return new Counter64(this.bean.getUptime());
                    }
                    case 6: {
                        return new Counter64(this.bean.getStartTime());
                    }
                    case 7: {
                        return Utils.stringToVariable(this.bean.getInstanceKey());
                    }
                    case 8: {
                        return new OctetString(this.bean.getSummaryData());
                    }
                    case 9: {
                        return new OctetString(this.bean.getClusterMembers());
                    }
                    case 10: {
                        return new OctetString(this.bean.getClusterBalancerMap());
                    }
                    case 11: {
                        return new OctetString(this.bean.getManagementServiceMap());
                    }
                    case 12: {
                        return new OctetString(this.bean.getAvailableUpdateVersion());
                    }
                }
                return super.getValue(column);
            }
            catch (Exception ex) {
                return new Integer32(-1);
            }
        }

        public void commit(SubRequest subRequest, MOTableRow changeSet, int column) {
            this.setValue(column, (Variable)subRequest.getVariableBinding().getVariable().clone());
            subRequest.completed();
        }

        public void setValue(int column, Variable newValue) {
            switch (column) {
                case 13: {
                    if (!(newValue instanceof Integer32) || ((Integer32)newValue).getValue() != 0) break;
                    this.bean.forceUpdateVersionCheck();
                    break;
                }
                default: {
                    super.setValue(column, newValue);
                }
            }
        }
    }

    private class GatewayMXBeanTableModel
    extends DefaultMOMutableTableModel {
        private GatewayMXBeanTableModel() {
        }
    }
}

