/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.mib;

import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.snmp.SummaryDataIntervalMO;
import org.kaazing.gateway.management.snmp.mib.MIBConstants;
import org.kaazing.gateway.management.system.CpuListManagementBean;
import org.kaazing.gateway.management.system.CpuManagementBean;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.AgentCapabilityList;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class CpuManagementMIB
implements MOGroup,
CounterListener,
AgentCapabilityList {
    private static final int NUM_CPUS_OPER = 1;
    private static final int SUMMARY_DATA_FIELDS_OPER = 2;
    private static final int SUMMARY_DATA_OPER = 3;
    private final ManagementContext managementContext;
    private DefaultMOTable sysOREntry;
    private DefaultMOMutableTableModel sysOREntryModel;
    private MOTableSubIndex[] entryIndexes;
    private MOTableIndex entryIndex;
    private MOTable cpuListEntry;
    private MOTableModel cpuEntryModel;
    private SystemInt numCpus;
    private SystemString summaryDataFields;
    private SystemString summaryData;
    private MOScalar summaryDataNotificationInterval;
    private MOScalar summaryDataGatherInterval;
    private CpuListManagementBean bean;

    public CpuManagementMIB(ManagementContext managementContext, MOFactory factory) {
        this.managementContext = managementContext;
        this.createMO(factory);
    }

    private void createMO(MOFactory moFactory) {
        OID cpuEntryIndexOID = ((OID)MIBConstants.oidCpuListEntry.clone()).append(1);
        this.entryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(cpuEntryIndexOID, 2, 1, 1)};
        this.entryIndex = moFactory.createIndex(this.entryIndexes, true);
        MOColumn[] entryColumns = new MOColumn[]{new MOMutableColumn(1, 2, moFactory.createAccess(1)), new MOMutableColumn(2, 70, moFactory.createAccess(1)), new MOMutableColumn(3, 70, moFactory.createAccess(1)), new MOMutableColumn(4, 70, moFactory.createAccess(1)), new MOMutableColumn(5, 70, moFactory.createAccess(1)), new MOMutableColumn(6, 70, moFactory.createAccess(1)), new MOMutableColumn(7, 70, moFactory.createAccess(1)), new MOMutableColumn(8, 70, moFactory.createAccess(1)), new MOMutableColumn(9, 70, moFactory.createAccess(1)), new MOMutableColumn(10, 70, moFactory.createAccess(1)), new MOMutableColumn(11, 70, moFactory.createAccess(1)), new MOMutableColumn(12, 4, moFactory.createAccess(1))};
        this.cpuEntryModel = new CpuManagementTableModel();
        this.cpuListEntry = moFactory.createTable(MIBConstants.oidCpuListEntry, this.entryIndex, entryColumns, this.cpuEntryModel);
        this.numCpus = new SystemInt(MIBConstants.oidCpuListNumCpus, moFactory.createAccess(9), (Variable)new Integer32(), 1);
        this.summaryDataFields = new SystemString(MIBConstants.oidCpuListSummaryDataFields, moFactory.createAccess(9), (Variable)new OctetString(), 2);
        this.summaryData = new SystemString(MIBConstants.oidCpuListSummaryData, moFactory.createAccess(9), (Variable)new OctetString(), 3);
        this.summaryDataNotificationInterval = new SummaryDataIntervalMO(moFactory, this.managementContext.getCpuListSummaryDataNotificationInterval(), MIBConstants.oidCpuListSummaryDataNotificationInterval);
        this.summaryDataGatherInterval = new SummaryDataIntervalMO(moFactory, this.managementContext.getCpuListSummaryDataGatherInterval(), MIBConstants.oidCpuListSummaryDataGatherInterval);
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register((ManagedObject)this.cpuListEntry, context);
        server.register((ManagedObject)this.numCpus, context);
        server.register((ManagedObject)this.summaryDataFields, context);
        server.register((ManagedObject)this.summaryData, context);
        server.register((ManagedObject)this.summaryDataNotificationInterval, context);
        server.register((ManagedObject)this.summaryDataGatherInterval, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister((ManagedObject)this.cpuListEntry, context);
        server.unregister((ManagedObject)this.numCpus, context);
        server.unregister((ManagedObject)this.summaryDataFields, context);
        server.unregister((ManagedObject)this.summaryData, context);
        server.unregister((ManagedObject)this.summaryDataNotificationInterval, context);
        server.unregister((ManagedObject)this.summaryDataGatherInterval, context);
    }

    public void addCpuListManagementBean(CpuListManagementBean cpuListManagementBean) {
        this.bean = cpuListManagementBean;
    }

    public void incrementCounter(CounterEvent event) {
    }

    public OID addSysOREntry(OID sysORID, OctetString sysORDescr) {
        OID index = new OID(new int[]{this.sysOREntryModel.getRowCount() + 1});
        Variable[] values = new Variable[this.sysOREntry.getColumnCount()];
        int n = 0;
        values[n++] = sysORID;
        values[n++] = sysORDescr;
        DefaultMOTableRow row = new DefaultMOTableRow(index, values);
        this.sysOREntry.addRow((MOTableRow)row);
        return index;
    }

    public MOTableRow removeSysOREntry(OID index) {
        return this.sysOREntry.removeRow(index);
    }

    public OID addCpuManagementBean(CpuManagementBean bean) {
        OID cpuIndexOID = new OID(new int[]{bean.getId()});
        this.cpuListEntry.addRow((MOTableRow)new CpuEntryRow(cpuIndexOID, bean));
        return cpuIndexOID;
    }

    public void removeCpuManagementBean(OID oid) {
        this.cpuListEntry.removeRow(oid);
    }

    class SystemInt
    extends MOScalar {
        private int operation;

        SystemInt(OID id, MOAccess access, Variable value, int operation) {
            super(id, access, value);
            this.operation = operation;
        }

        public Variable getValue() {
            int value = -1;
            switch (this.operation) {
                case 1: {
                    value = CpuManagementMIB.this.bean.getNumCpus();
                    break;
                }
                default: {
                    throw new RuntimeException("SystemString incorrectly configured with unsupported operation: " + this.operation);
                }
            }
            Integer32 val = new Integer32(value);
            return val;
        }
    }

    class SystemString
    extends MOScalar {
        private int operation;

        SystemString(OID id, MOAccess access, Variable value, int operation) {
            super(id, access, value);
            this.operation = operation;
        }

        public Variable getValue() {
            String value = "";
            switch (this.operation) {
                case 2: {
                    value = CpuManagementMIB.this.bean.getSummaryDataFields();
                    break;
                }
                case 3: {
                    value = CpuManagementMIB.this.bean.getSummaryData();
                    break;
                }
                default: {
                    throw new RuntimeException("SystemString incorrectly configured with unsupported operation: " + this.operation);
                }
            }
            OctetString val = (OctetString)Utils.stringToVariable(value);
            return val;
        }
    }

    private class CpuEntryRow
    extends DefaultMOMutableRow2PC {
        private CpuManagementBean bean;

        private CpuEntryRow(OID index, CpuManagementBean bean) {
            super(index, null);
            this.bean = bean;
        }

        public int size() {
            return 12;
        }

        public Variable getValue(int column) {
            Number scalarValue = null;
            try {
                switch (column) {
                    case 0: {
                        return new Integer32(this.getIndex().last());
                    }
                    case 1: {
                        scalarValue = this.bean.getId();
                        break;
                    }
                    case 2: {
                        scalarValue = this.bean.getCombined();
                        break;
                    }
                    case 3: {
                        scalarValue = this.bean.getIdle();
                        break;
                    }
                    case 4: {
                        scalarValue = this.bean.getIrq();
                        break;
                    }
                    case 5: {
                        scalarValue = this.bean.getNice();
                        break;
                    }
                    case 6: {
                        scalarValue = this.bean.getSoftIrq();
                        break;
                    }
                    case 7: {
                        scalarValue = this.bean.getStolen();
                        break;
                    }
                    case 8: {
                        scalarValue = this.bean.getSys();
                        break;
                    }
                    case 9: {
                        scalarValue = this.bean.getUser();
                        break;
                    }
                    case 10: {
                        scalarValue = this.bean.getWait();
                        break;
                    }
                    case 11: {
                        return Utils.stringToVariable(this.bean.getSummaryData());
                    }
                    default: {
                        return super.getValue(column);
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (scalarValue == null) {
                return new Null();
            }
            long counterValue = 0L;
            counterValue = scalarValue instanceof Double ? (long)((Double)scalarValue * 1000.0) : (scalarValue instanceof Float ? (long)(((Float)scalarValue).floatValue() * 1000.0f) : ((Number)scalarValue).longValue());
            return new Counter64(counterValue);
        }

        public void commit(SubRequest subRequest, MOTableRow changeSet, int column) {
            this.setValue(column, (Variable)subRequest.getVariableBinding().getVariable().clone());
            subRequest.completed();
        }
    }

    private class CpuManagementTableModel
    extends DefaultMOMutableTableModel {
        private CpuManagementTableModel() {
        }
    }
}

