/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.update.check;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GatewayVersion
implements Comparable<GatewayVersion> {
    private static final String RELEASE_GA = "";
    private static final String VERSION = "develop-SNAPSHOT";
    private final int major;
    private final int minor;
    private final int patch;
    private final String rc;

    public GatewayVersion(int major, int minor, int patch, String rc) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.rc = rc;
    }

    public GatewayVersion(int major, int minor, int patch) {
        this(major, minor, patch, RELEASE_GA);
    }

    public static GatewayVersion parseGatewayVersion(String version) {
        if (VERSION.equals(version)) {
            return new GatewayVersion(0, 0, 0);
        }
        String regex = "(?<major>[0-9]+)\\.(?<minor>[0-9]+)\\.(?<patch>[0-9]+)-?(?<rc>[RC0-9{3}]*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(version);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group("major"));
            int minor = Integer.parseInt(matcher.group("minor"));
            int patch = Integer.parseInt(matcher.group("patch"));
            String rc = matcher.group("rc");
            return new GatewayVersion(major, minor, patch, rc);
        }
        throw new IllegalArgumentException(String.format("version String is not of form %s", regex));
    }

    public int getMajor() {
        return this.major;
    }

    public boolean equals(Object obj) {
        boolean result = !(obj instanceof GatewayVersion) ? false : (obj == this ? true : this.compareTo((GatewayVersion)obj) == 0);
        return result;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + (this.rc != null ? this.rc.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.rc.equals(RELEASE_GA)) {
            return String.format("%d.%d.%d", this.major, this.minor, this.patch);
        }
        return String.format("%d.%d.%d-%s", this.major, this.minor, this.patch, this.rc);
    }

    @Override
    public int compareTo(GatewayVersion o) {
        int result = this.major != o.major ? (this.major > o.major ? 1 : -1) : (this.minor != o.minor ? (this.minor > o.minor ? 1 : -1) : (this.patch != o.patch ? (this.patch > o.patch ? 1 : -1) : (!this.rc.equals(o.rc) ? (RELEASE_GA.equals(this.rc) ? 1 : (RELEASE_GA.equals(o.rc) ? -1 : this.rc.compareTo(o.rc))) : 0)));
        return result;
    }
}

