/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.lang.builder;

import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jvnet.jaxb2_commons.lang.Equals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBEqualsBuilder
extends EqualsBuilder {
    public EqualsBuilder append(Object lhs, Object rhs) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        Class<?> lhsClass = lhs.getClass();
        if (lhsClass.isArray()) {
            super.append(lhs, rhs);
        } else if (lhs instanceof Iterable && rhs instanceof Iterable) {
            this.append((Iterable)lhs, (Iterable)rhs);
        } else if (lhs instanceof JAXBElement && rhs instanceof JAXBElement) {
            this.append((JAXBElement)lhs, (JAXBElement)rhs);
        } else if (lhs instanceof Equals) {
            ((Equals)lhs).equals(rhs, this);
        } else {
            this.setEquals(lhs.equals(rhs));
        }
        return this;
    }

    public EqualsBuilder append(Iterable<?> lhs, Iterable<?> rhs) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        Iterator<?> e1 = lhs.iterator();
        Iterator<?> e2 = rhs.iterator();
        while (e1.hasNext() && e2.hasNext() && this.isEquals()) {
            this.append(e1.next(), e2.next());
        }
        this.setEquals(!e1.hasNext() && !e2.hasNext());
        return this;
    }

    public EqualsBuilder append(JAXBElement<?> lhs, JAXBElement<?> rhs) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        this.append(lhs.getName(), rhs.getName()).append((Object)lhs.getScope(), (Object)rhs.getScope()).append(lhs.getValue(), rhs.getValue());
        return this;
    }
}

