/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.setters;

import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldAccessor;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.CustomizedIgnoring;
import org.jvnet.jaxb2_commons.plugin.Ignoring;
import org.jvnet.jaxb2_commons.plugin.setters.Customizations;
import org.jvnet.jaxb2_commons.plugin.util.FieldOutlineUtils;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettersPlugin
extends AbstractParameterizablePlugin {
    private static final JType[] ABSENT = new JType[0];
    private Ignoring ignoring = new CustomizedIgnoring(Customizations.IGNORED_ELEMENT_NAME);

    public String getOptionName() {
        return "Xsetters";
    }

    public String getUsage() {
        return "Generates setters for collections.";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (this.getIgnoring().isIgnored(classOutline)) continue;
            this.processClassOutline(classOutline);
        }
        return true;
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        this.generateSetters(classOutline, theClass);
    }

    private void generateSetters(ClassOutline classOutline, JDefinedClass theClass) {
        FieldOutline[] declaredFields;
        for (FieldOutline fieldOutline : declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())) {
            JMethod setter;
            String publicName = fieldOutline.getPropertyInfo().getName(true);
            String getterName = "get" + publicName;
            JMethod getter = theClass.getMethod(getterName, ABSENT);
            if (getter == null) continue;
            JType type = getter.type();
            JType rawType = fieldOutline.getRawType();
            String setterName = "set" + publicName;
            JMethod boxifiedSetter = theClass.getMethod(setterName, new JType[]{rawType.boxify()});
            JMethod unboxifiedSetter = theClass.getMethod(setterName, new JType[]{rawType.unboxify()});
            JMethod jMethod = setter = boxifiedSetter != null ? boxifiedSetter : unboxifiedSetter;
            if (setter != null) continue;
            JMethod generatedSetter = theClass.method(1, (JType)theClass.owner().VOID, setterName);
            JVar value = generatedSetter.param(type, "value");
            FieldAccessor accessor = fieldOutline.create(JExpr._this());
            accessor.unsetValues(generatedSetter.body());
            accessor.fromRawValue(generatedSetter.body(), "draft", (JExpression)value);
        }
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.IGNORED_ELEMENT_NAME);
    }
}

