/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.inheritance;

import com.sun.codemodel.JClass;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.inheritance.Customizations;
import org.jvnet.jaxb2_commons.plugin.inheritance.ExtendsClass;
import org.jvnet.jaxb2_commons.plugin.inheritance.ImplementsInterface;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritancePlugin
extends AbstractParameterizablePlugin {
    public String getOptionName() {
        return "Xinheritance";
    }

    public String getUsage() {
        return "TBD";
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.EXTENDS_ELEMENT_NAME, Customizations.IMPLEMENTS_ELEMENT_NAME);
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline);
        }
        return true;
    }

    protected void processClassOutline(ClassOutline classOutline) {
        this.generateExtends(classOutline);
        this.generateImplements(classOutline);
    }

    private void generateExtends(ClassOutline classOutline) {
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((ClassOutline)classOutline, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        if (extendsClassCustomization != null) {
            ExtendsClass extendsClass = (ExtendsClass)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)extendsClassCustomization);
            String name = extendsClass.getClassName();
            JClass targetClass = classOutline.implClass.owner().ref(name);
            classOutline.implClass._extends(targetClass);
        }
    }

    private void generateImplements(ClassOutline classOutline) {
        List implementsInterfaceCustomizations = CustomizationUtils.findCustomizations((ClassOutline)classOutline, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        for (CPluginCustomization implementsInterfaceCustomization : implementsInterfaceCustomizations) {
            ImplementsInterface implementsInterface;
            if (implementsInterfaceCustomization == null || (implementsInterface = (ImplementsInterface)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)implementsInterfaceCustomization)).getInterfaceName() == null) continue;
            JClass targetClass = classOutline.implClass.owner().ref(implementsInterface.getInterfaceName());
            classOutline.implClass._implements(targetClass);
        }
    }
}

