/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.codegenerator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import jakarta.xml.bind.JAXBElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jvnet.jaxb.codemodel.JCMType;
import org.jvnet.jaxb.codemodel.JCMTypeFactory;
import org.jvnet.jaxb.plugin.codegenerator.Arguments;
import org.jvnet.jaxb.plugin.codegenerator.ArrayCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.BooleanCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.ByteCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.CharCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.CodeGenerationImplementor;
import org.jvnet.jaxb.plugin.codegenerator.CodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.DoubleCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.FloatCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.IntCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.JAXBElementCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.ListCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.LongCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.ObjectCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.ShortCodeGenerator;

public class CodeGenerationAbstraction<A extends Arguments<A>>
implements CodeGenerator<A> {
    private final JCodeModel codeModel;
    private final JCMTypeFactory typeFactory = JCMTypeFactory.INSTANCE;
    private final Map<JCMType<?>, CodeGenerator<A>> codeGenerators = new LinkedHashMap();
    private final CodeGenerator<A> defaultCodeGenerator;
    private final CodeGenerationImplementor<A> implementor;

    public CodeGenerationAbstraction(CodeGenerationImplementor<A> generationImplementor) {
        this.implementor = Objects.requireNonNull(generationImplementor, "generationImplementor must not be null");
        this.codeModel = generationImplementor.getCodeModel();
        this.addCodeGenerator((JType)this.codeModel.BOOLEAN, new BooleanCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.BYTE, new ByteCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.CHAR, new CharCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.DOUBLE, new DoubleCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.FLOAT, new FloatCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.LONG, new LongCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.INT, new IntCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.SHORT, new ShortCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.BOOLEAN.array(), new ArrayCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.BYTE.array(), new ArrayCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.SHORT.array(), new ArrayCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.CHAR.array(), new ArrayCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.INT.array(), new ArrayCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.FLOAT.array(), new ArrayCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.LONG.array(), new ArrayCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.DOUBLE.array(), new ArrayCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.ref(Object.class).array(), new ArrayCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.ref(JAXBElement.class).narrow(Object.class), new JAXBElementCodeGenerator<A>(this, this.implementor, this.typeFactory));
        this.addCodeGenerator((JType)this.codeModel.ref(List.class).narrow(Object.class), new ListCodeGenerator<A>(this, this.implementor));
        this.addCodeGenerator((JType)this.codeModel.ref(Object.class), new ObjectCodeGenerator<A>(this, this.implementor));
        this.defaultCodeGenerator = new ObjectCodeGenerator<A>(this, this.implementor);
    }

    private void addCodeGenerator(JType type, CodeGenerator<A> codeGenerator) {
        JCMType factoredType = this.typeFactory.create(type);
        this.codeGenerators.put(factoredType, codeGenerator);
    }

    private CodeGenerator<A> getCodeGenerator(JType type) {
        JCMType factoredType = this.typeFactory.create(type);
        for (Map.Entry<JCMType<?>, CodeGenerator<A>> entry : this.codeGenerators.entrySet()) {
            if (!entry.getKey().matches(factoredType)) continue;
            return entry.getValue();
        }
        return this.defaultCodeGenerator;
    }

    @Override
    public void generate(JBlock block, JType type, Collection<JType> possibleTypes, boolean isAlwaysSet, A arguments) {
        this.getCodeGenerator(type).generate(block, type, possibleTypes, isAlwaysSet, arguments);
    }
}

