/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.inheritance.util;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jvnet.jaxb.plugin.inheritance.util.TypeToJTypeConvertingVisitor;

public class JavaTypeParser {
    private final TypeToJTypeConvertingVisitor typeToJTypeConvertingVisitor;

    public JavaTypeParser() {
        this(Collections.emptyMap());
    }

    public JavaTypeParser(Map<String, JClass> knownClasses) {
        Objects.requireNonNull(knownClasses, "Known classes must not be null. Use empty map instead of null to indicate no known classes.");
        this.typeToJTypeConvertingVisitor = new TypeToJTypeConvertingVisitor(knownClasses);
    }

    public JClass parseClass(String _class, JCodeModel codeModel) {
        JType type = this.parseType(_class, codeModel);
        if (type instanceof JClass) {
            return (JClass)type;
        }
        throw new IllegalArgumentException("Type [" + _class + "] is not a class.");
    }

    private JType parseType(String type, JCodeModel codeModel) {
        String text = "public class Ignored extends " + type + " {}";
        try {
            CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(text.getBytes("UTF-8")), (Charset)StandardCharsets.UTF_8);
            NodeList typeDeclarations = compilationUnit.getTypes();
            TypeDeclaration typeDeclaration = (TypeDeclaration)typeDeclarations.get(0);
            ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)typeDeclaration;
            NodeList _extended = classDeclaration.getExtendedTypes();
            ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)_extended.get(0);
            return (JType)classOrInterfaceType.accept((GenericVisitor)this.typeToJTypeConvertingVisitor, (Object)codeModel);
        }
        catch (ParseProblemException pex) {
            throw new IllegalArgumentException("Could not parse the type definition [" + type + "].", pex);
        }
        catch (UnsupportedEncodingException uex) {
            throw new UnsupportedOperationException(uex);
        }
    }
}

