package org.jvnet.jaxb.test;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractSamplesTest {

	protected Log logger = LogFactory.getLog(getTestClass());

	protected String getContextPath() {
		return getTestClass().getPackage().getName();
	}

	protected abstract void checkSample(File sample) throws Exception;

    @Test
	public void testSamples() throws Exception {
		logger.debug("Testing samples.");
		int failed = 0;
		final File[] sampleFiles = getSampleFiles();
		for (final File sampleFile : sampleFiles) {
			logger.debug("Testing sample [" + sampleFile.getName() + "].");
			try {
				checkSample(sampleFile);
			} catch (Throwable ex) {
				logger.error("Sample [" + sampleFile.getName()
						+ "] failed the check.", ex);
				failed++;
			}
			logger.debug("Finished testing sample [" + sampleFile.getName()
					+ "].");
		}
		logger.debug("Finished testing samples.");

		Assertions.assertTrue(failed == 0,
            "Totally [" + failed + "/" + sampleFiles.length + "] failed the check.");
	}

	protected File getBaseDir() {
		try {
			return (new File(getTestClass().getProtectionDomain()
					.getCodeSource().getLocation().getFile())).getParentFile()
					.getParentFile().getAbsoluteFile();
		} catch (Exception ex) {
			throw new AssertionError(ex);
		}
	}

	protected Class<? extends Object> getTestClass() {
		return getClass();
	}

	protected File getSamplesDirectory() {
		return new File(getBaseDir(), getSamplesDirectoryName());
	}

	public static final String DEFAULT_SAMPLES_DIRECTORY_NAME = "src/test/samples";

	protected String getSamplesDirectoryName() {
		return DEFAULT_SAMPLES_DIRECTORY_NAME;
	}

	protected File[] getSampleFiles() {
		File samplesDirectory = getSamplesDirectory();
		logger.debug("Sample directory [" + samplesDirectory.getAbsolutePath() + "].");
		return samplesDirectory.listFiles(new FilenameFilter() {
            @Override
            public boolean accept(File file, String name) {
                return name != null && name.endsWith("xml");
            }
        });
	}

	protected ClassLoader getContextClassLoader() {
		return getTestClass().getClassLoader();
	}

	protected Map<String, ?> getContextProperties() {
		return null;
	}

	public JAXBContext createContext() throws JAXBException {
		final String contextPath = getContextPath();
		final ClassLoader classLoader = getContextClassLoader();
		final Map<String, ?> properties = getContextProperties();
		if (classLoader == null) {
			return JAXBContext.newInstance(contextPath);
		} else {
			if (properties == null) {
				return JAXBContext.newInstance(contextPath, classLoader);
			} else {
				return JAXBContext.newInstance(contextPath, classLoader,
						properties);
			}
		}
	}
}
