/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.xml.bind.annotation.adapters;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import org.jvnet.hyperjaxb3.item.Converter;
import org.jvnet.hyperjaxb3.xml.bind.annotation.adapters.XmlAdapterConverter;

public class XmlAdapterUtils {
    public static <I, O> Converter<I, O> getConverter(Class<? extends XmlAdapter<O, I>> xmlAdapterClass) {
        return XmlAdapterUtils.asConverter(XmlAdapterUtils.getXmlAdapter(xmlAdapterClass));
    }

    public static <I, O> Converter<I, O> asConverter(XmlAdapter<O, I> adapter) {
        return new XmlAdapterConverter<I, O>(adapter);
    }

    public static <ValueType, BoundType> ValueType marshall(Class<? extends XmlAdapter<ValueType, BoundType>> xmlAdapterClass, BoundType v) {
        try {
            XmlAdapter<ValueType, BoundType> xmlAdapter = XmlAdapterUtils.getXmlAdapter(xmlAdapterClass);
            return (ValueType)xmlAdapter.marshal(v);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <ValueType, BoundType> BoundType unmarshall(Class<? extends XmlAdapter<ValueType, BoundType>> xmlAdapterClass, ValueType v) {
        try {
            XmlAdapter<ValueType, BoundType> xmlAdapter = XmlAdapterUtils.getXmlAdapter(xmlAdapterClass);
            return (BoundType)xmlAdapter.unmarshal(v);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <ValueType, BoundType> XmlAdapter<ValueType, BoundType> getXmlAdapter(Class<? extends XmlAdapter<ValueType, BoundType>> xmlAdapterClass) {
        try {
            XmlAdapter<ValueType, BoundType> xmlAdapter = xmlAdapterClass.newInstance();
            return xmlAdapter;
        }
        catch (IllegalAccessException iaex) {
            throw new RuntimeException(iaex);
        }
        catch (InstantiationException iex) {
            throw new RuntimeException(iex);
        }
    }

    public static <ValueType, BoundType> ValueType unmarshallJAXBElement(Class<? extends XmlAdapter<BoundType, ValueType>> xmlAdapterClass, JAXBElement<? extends BoundType> v) {
        try {
            if (v == null) {
                return null;
            }
            XmlAdapter<ValueType, BoundType> xmlAdapter = XmlAdapterUtils.getXmlAdapter(xmlAdapterClass);
            return (ValueType)xmlAdapter.unmarshal(v.getValue());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <BoundType> BoundType unmarshallJAXBElement(JAXBElement<? extends BoundType> v) {
        if (v == null) {
            return null;
        }
        return (BoundType)v.getValue();
    }

    public static <BoundType> boolean isJAXBElement(Class<BoundType> declaredType, QName name, Class<?> scope, Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof JAXBElement) {
            JAXBElement element = (JAXBElement)value;
            return element.getName().equals(name) && declaredType.isAssignableFrom(element.getDeclaredType());
        }
        return false;
    }

    public static <ValueType, BoundType> JAXBElement<BoundType> marshallJAXBElement(Class<? extends XmlAdapter<BoundType, ValueType>> xmlAdapterClass, Class<BoundType> declaredType, QName name, Class<?> scope, ValueType v) {
        try {
            if (v == null) {
                return null;
            }
            XmlAdapter<ValueType, BoundType> xmlAdapter = XmlAdapterUtils.getXmlAdapter(xmlAdapterClass);
            return new JAXBElement(name, declaredType, scope, xmlAdapter.marshal(v));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <BoundType> JAXBElement<BoundType> marshallJAXBElement(Class<BoundType> declaredType, QName name, Class<?> scope, BoundType v) {
        if (v == null) {
            return null;
        }
        return new JAXBElement(name, declaredType, scope, v);
    }
}

