/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.test;

import jakarta.persistence.EntityManager;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.jvnet.hyperjaxb3.ejb.test.AbstractEntityManagerSamplesTest;
import org.jvnet.hyperjaxb3.ejb.util.EntityUtils;
import org.jvnet.hyperjaxb3.lang.builder.ExtendedJAXBEqualsStrategy;
import org.jvnet.jaxb.lang.ContextUtils;
import org.jvnet.jaxb.locator.DefaultRootObjectLocator;
import org.jvnet.jaxb.locator.ObjectLocator;

public abstract class RoundtripTest
extends AbstractEntityManagerSamplesTest {
    @Override
    protected void checkSample(File sample) throws Exception {
        Object etalonObject;
        JAXBElement etalonElement;
        Object unmarshalledObject;
        JAXBElement unmarshalledElement;
        JAXBContext context = this.createContext();
        this.logger.debug((Object)"Unmarshalling.");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Object unmarshalledDraft = unmarshaller.unmarshal(sample);
        if (unmarshalledDraft instanceof JAXBElement) {
            unmarshalledElement = (JAXBElement)unmarshalledDraft;
            unmarshalledObject = unmarshalledElement.getValue();
        } else {
            unmarshalledElement = null;
            unmarshalledObject = unmarshalledDraft;
        }
        Object etalonDraft = unmarshaller.unmarshal(sample);
        if (etalonDraft instanceof JAXBElement) {
            etalonElement = (JAXBElement)etalonDraft;
            etalonObject = etalonElement.getValue();
        } else {
            etalonElement = null;
            etalonObject = etalonDraft;
        }
        this.logger.debug((Object)"Opening session.");
        this.logger.debug((Object)"Saving the object.");
        EntityManager saveManager = this.createEntityManager();
        saveManager.getTransaction().begin();
        Object mergedObject = saveManager.merge(unmarshalledObject);
        saveManager.getTransaction().commit();
        Object id = EntityUtils.getId((EntityManager)saveManager, (Object)mergedObject);
        saveManager.clear();
        saveManager.close();
        this.logger.debug((Object)"Opening session.");
        EntityManager loadManager = this.createEntityManager();
        this.logger.debug((Object)"Loading the object.");
        Object loadedObject = loadManager.find(mergedObject.getClass(), id);
        this.logger.debug((Object)"Closing the session.");
        if (unmarshalledElement != null) {
            JAXBElement mergedElement = new JAXBElement(unmarshalledElement.getName(), unmarshalledElement.getDeclaredType(), mergedObject);
            JAXBElement loadedElement = new JAXBElement(unmarshalledElement.getName(), unmarshalledElement.getDeclaredType(), loadedObject);
            this.logger.debug((Object)("Initial object:\n" + ContextUtils.toString((JAXBContext)context, (Object)etalonElement)));
            this.logger.debug((Object)("Source object:\n" + ContextUtils.toString((JAXBContext)context, (Object)mergedElement)));
            this.logger.debug((Object)("Result object:\n" + ContextUtils.toString((JAXBContext)context, (Object)loadedElement)));
        } else {
            this.logger.debug((Object)("Initial object:\n" + ContextUtils.toString((JAXBContext)context, (Object)etalonObject)));
            this.logger.debug((Object)("Source object:\n" + ContextUtils.toString((JAXBContext)context, (Object)mergedObject)));
            this.logger.debug((Object)("Result object:\n" + ContextUtils.toString((JAXBContext)context, (Object)loadedObject)));
        }
        this.logger.debug((Object)"Checking the document identity.");
        this.checkObjects(mergedObject, loadedObject);
        this.checkObjects(etalonObject, loadedObject);
        loadManager.close();
    }

    protected void checkObjects(Object object, Object loadedObject) {
        ExtendedJAXBEqualsStrategy strategy = new ExtendedJAXBEqualsStrategy(){

            public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, Object lhs, Object rhs) {
                if (!super.equals(leftLocator, rightLocator, lhs, rhs)) {
                    RoundtripTest.this.logger.debug((Object)("Objects are not equal.\nLeft: " + (lhs == null ? "null" : lhs.toString()) + (String)(leftLocator == null ? "" : "\nAt [" + leftLocator.getPathAsString() + "].") + "\nRight: " + (rhs == null ? "null" : rhs.toString()) + (String)(rightLocator == null ? "" : "\nAt [" + rightLocator.getPathAsString() + "].")));
                    return false;
                }
                return true;
            }
        };
        Assertions.assertTrue((boolean)strategy.equals((ObjectLocator)new DefaultRootObjectLocator(object), (ObjectLocator)new DefaultRootObjectLocator(loadedObject), object, loadedObject, true, true), (String)"Objects must be equal.");
    }
}

