/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.test;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractEntityManagerTest {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected Class lastTestClass;
    protected EntityManagerFactory entityManagerFactory;

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @BeforeEach
    public void setUp() throws Exception {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf == null || !emf.isOpen() || this.lastTestClass != this.getClass()) {
            this.setEntityManagerFactory(this.createEntityManagerFactory());
            this.lastTestClass = this.getClass();
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    public String getPersistenceUnitName() {
        Package _package = this.getClass().getPackage();
        String name = _package.getName();
        if (name == null) {
            return "root";
        }
        return name;
    }

    public Map getEntityManagerProperties() {
        return null;
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        Map properties;
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/persistence.xml");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                this.logger.debug((Object)("Detected [" + String.valueOf(resource) + "]."));
            }
        }
        catch (IOException resources) {
            // empty catch block
        }
        if ((properties = this.getEntityManagerFactoryProperties()) == null) {
            return Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName());
        }
        return Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map getEntityManagerFactoryProperties() {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(this.getEntityManagerFactoryPropertiesResourceName());
            if (!resources.hasMoreElements()) {
                this.logger.debug((Object)"Entity manager factory properties are not set.");
                return null;
            }
            this.logger.debug((Object)"Loading entity manager factory properties.");
            Properties properties = new Properties();
            if (!resources.hasMoreElements()) return properties;
            URL resource = resources.nextElement();
            this.logger.debug((Object)("Loading entity manager factory properties from [" + String.valueOf(resource) + "]."));
            if (resource == null) {
                return null;
            }
            InputStream is = null;
            try {
                is = resource.openStream();
                properties.load(is);
                Properties properties2 = properties;
                return properties2;
            }
            catch (IOException ex) {
                Map map = null;
                return map;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException ex2) {
            return null;
        }
    }

    public String getEntityManagerFactoryPropertiesResourceName() {
        return "persistence.properties";
    }

    public EntityManager createEntityManager() {
        Map properties = this.getEntityManagerProperties();
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (properties == null) {
            return emf.createEntityManager();
        }
        return emf.createEntityManager(properties);
    }
}

