/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.Hudson;
import hudson.plugins.analysis.util.EncodingValidator;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.GroovyParser;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.parser.AcuCobolParser;
import hudson.plugins.warnings.parser.AntJavacParser;
import hudson.plugins.warnings.parser.BuckminsterParser;
import hudson.plugins.warnings.parser.CoolfluxChessccParser;
import hudson.plugins.warnings.parser.DoxygenParser;
import hudson.plugins.warnings.parser.DynamicDocumentParser;
import hudson.plugins.warnings.parser.DynamicParser;
import hudson.plugins.warnings.parser.EclipseParser;
import hudson.plugins.warnings.parser.ErlcParser;
import hudson.plugins.warnings.parser.FlexSDKParser;
import hudson.plugins.warnings.parser.Gcc4CompilerParser;
import hudson.plugins.warnings.parser.Gcc4LinkerParser;
import hudson.plugins.warnings.parser.GccParser;
import hudson.plugins.warnings.parser.GhsMultiParser;
import hudson.plugins.warnings.parser.GnatParser;
import hudson.plugins.warnings.parser.IarParser;
import hudson.plugins.warnings.parser.IntelCParser;
import hudson.plugins.warnings.parser.InvalidsParser;
import hudson.plugins.warnings.parser.JavaDocParser;
import hudson.plugins.warnings.parser.JavacParser;
import hudson.plugins.warnings.parser.MsBuildParser;
import hudson.plugins.warnings.parser.P4Parser;
import hudson.plugins.warnings.parser.PhpParser;
import hudson.plugins.warnings.parser.RegexpParser;
import hudson.plugins.warnings.parser.RobocopyParser;
import hudson.plugins.warnings.parser.SunCParser;
import hudson.plugins.warnings.parser.TiCcsParser;
import hudson.plugins.warnings.parser.TnsdlParser;
import hudson.plugins.warnings.parser.WarningsParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRegistry {
    private final List<WarningsParser> parsers;
    private final Charset defaultCharset;
    private final Set<Pattern> includePatterns = Sets.newHashSet();
    private final Set<Pattern> excludePatterns = Sets.newHashSet();

    public static List<String> getAvailableParsers() {
        ArrayList<String> sortedParsers = new ArrayList<String>(ParserRegistry.getAllParserNames());
        Collections.sort(sortedParsers);
        return Collections.unmodifiableList(sortedParsers);
    }

    private static Set<String> getAllParserNames() {
        HashSet<String> parsers = new HashSet<String>();
        for (WarningsParser parser : ParserRegistry.getAllParsers()) {
            parsers.add(parser.getName());
        }
        return parsers;
    }

    public static List<WarningsParser> getParsers(Set<String> parserNames) {
        ArrayList<WarningsParser> actualParsers = new ArrayList<WarningsParser>();
        for (String name : parserNames) {
            for (WarningsParser warningsParser : ParserRegistry.getAllParsers()) {
                if (!warningsParser.getName().equals(name)) continue;
                actualParsers.add(warningsParser);
            }
        }
        return actualParsers;
    }

    public static List<String> filterExistingParserNames(Set<String> parserNames) {
        ArrayList validNames = Lists.newArrayList();
        Set<String> allParsers = ParserRegistry.getAllParserNames();
        for (String name : parserNames) {
            if (!allParsers.contains(name)) continue;
            validNames.add(name);
        }
        Collections.sort(validNames);
        return validNames;
    }

    private static List<WarningsParser> getAllParsers() {
        ArrayList<WarningsParser> parsers = new ArrayList<WarningsParser>();
        parsers.add(new JavacParser());
        parsers.add(new AntJavacParser());
        parsers.add(new JavaDocParser());
        parsers.add(new EclipseParser());
        parsers.add(new MsBuildParser());
        parsers.add(new GccParser());
        parsers.add(new Gcc4CompilerParser());
        parsers.add(new Gcc4LinkerParser());
        parsers.add(new InvalidsParser());
        parsers.add(new SunCParser());
        parsers.add(new GnatParser());
        parsers.add(new ErlcParser());
        parsers.add(new IntelCParser());
        parsers.add(new IarParser());
        MsBuildParser pclintParser = new MsBuildParser();
        pclintParser.setName("PC-Lint");
        parsers.add(pclintParser);
        parsers.add(new BuckminsterParser());
        parsers.add(new TiCcsParser());
        parsers.add(new AcuCobolParser());
        parsers.add(new FlexSDKParser());
        parsers.add(new PhpParser());
        parsers.add(new CoolfluxChessccParser());
        parsers.add(new P4Parser());
        parsers.add(new RobocopyParser());
        parsers.add(new DoxygenParser());
        parsers.add(new TnsdlParser());
        parsers.add(new GhsMultiParser());
        Iterable<GroovyParser> parserDescriptions = ParserRegistry.getDynamicParserDescriptions();
        parsers.addAll(ParserRegistry.getDynamicParsers(parserDescriptions));
        return ImmutableList.copyOf(parsers);
    }

    private static Iterable<GroovyParser> getDynamicParserDescriptions() {
        WarningsDescriptor descriptor;
        Hudson instance = Hudson.getInstance();
        if (instance != null && (descriptor = (WarningsDescriptor)instance.getDescriptorByType(WarningsDescriptor.class)) != null) {
            return descriptor.getParsers();
        }
        return Collections.emptyList();
    }

    static List<WarningsParser> getDynamicParsers(Iterable<GroovyParser> parserDescriptions) {
        ArrayList<WarningsParser> parsers = new ArrayList<WarningsParser>();
        for (GroovyParser description : parserDescriptions) {
            if (!description.isValid()) continue;
            RegexpParser parser = description.hasMultiLineSupport() ? new DynamicDocumentParser(description.getName(), description.getRegexp(), description.getScript()) : new DynamicParser(description.getName(), description.getRegexp(), description.getScript());
            parsers.add(parser);
        }
        return parsers;
    }

    public ParserRegistry(List<WarningsParser> parsers, String defaultEncoding) {
        this(parsers, defaultEncoding, "", "");
    }

    public ParserRegistry(List<? extends WarningsParser> parsers, String defaultEncoding, String includePattern, String excludePattern) {
        this.defaultCharset = EncodingValidator.defaultCharset((String)defaultEncoding);
        this.parsers = new ArrayList<WarningsParser>(parsers);
        if (this.parsers.isEmpty()) {
            this.parsers.addAll(ParserRegistry.getAllParsers());
        }
        this.addPatterns(this.includePatterns, includePattern);
        this.addPatterns(this.excludePatterns, excludePattern);
    }

    private void addPatterns(Set<Pattern> patterns, String pattern) {
        if (StringUtils.isNotBlank((String)pattern)) {
            String[] splitted;
            for (String singlePattern : splitted = StringUtils.split((String)pattern, (char)',')) {
                String trimmed = StringUtils.trim((String)singlePattern);
                String directoriesReplaced = StringUtils.replace((String)trimmed, (String)"**", (String)"*");
                patterns.add(Pattern.compile(StringUtils.replace((String)directoriesReplaced, (String)"*", (String)".*")));
            }
        }
    }

    public Collection<FileAnnotation> parse(File file) throws IOException {
        return this.parse(file, new NullLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileAnnotation> parse(File file, PluginLogger logger) throws IOException {
        HashSet allAnnotations = Sets.newHashSet();
        for (WarningsParser parser : this.parsers) {
            Reader input = null;
            try {
                input = this.createReader(file);
                Collection<FileAnnotation> warnings = parser.parse(input);
                logger.log(String.format("%s : Found %d warnings.", parser.getName(), warnings.size()));
                allAnnotations.addAll(warnings);
            }
            finally {
                IOUtils.closeQuietly((Reader)input);
            }
        }
        return this.applyExcludeFilter(allAnnotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileAnnotation> parse(InputStream file) throws IOException {
        try {
            HashSet allAnnotations = Sets.newHashSet();
            for (WarningsParser parser : this.parsers) {
                allAnnotations.addAll(parser.parse(this.createReader(file)));
            }
            Set<FileAnnotation> set = this.applyExcludeFilter(allAnnotations);
            return set;
        }
        finally {
            IOUtils.closeQuietly((InputStream)file);
        }
    }

    private Set<FileAnnotation> applyExcludeFilter(Set<FileAnnotation> allAnnotations) {
        HashSet includedAnnotations;
        if (this.includePatterns.isEmpty()) {
            includedAnnotations = allAnnotations;
        } else {
            includedAnnotations = Sets.newHashSet();
            for (FileAnnotation annotation : allAnnotations) {
                for (Pattern include : this.includePatterns) {
                    if (!include.matcher(annotation.getFileName()).matches()) continue;
                    includedAnnotations.add(annotation);
                }
            }
        }
        if (this.excludePatterns.isEmpty()) {
            return includedAnnotations;
        }
        HashSet excludedAnnotations = Sets.newHashSet((Iterable)includedAnnotations);
        for (FileAnnotation annotation : includedAnnotations) {
            for (Pattern exclude : this.excludePatterns) {
                if (!exclude.matcher(annotation.getFileName()).matches()) continue;
                excludedAnnotations.remove(annotation);
            }
        }
        return excludedAnnotations;
    }

    @SuppressWarnings(value={"OBL"})
    protected Reader createReader(File file) throws FileNotFoundException {
        return this.createReader(new FileInputStream(file));
    }

    protected Reader createReader(InputStream inputStream) {
        return new InputStreamReader(inputStream, this.defaultCharset);
    }

    public static final class NullLogger
    extends PluginLogger {
        public NullLogger() {
            super(null, null);
        }

        public void log(String message) {
        }

        public void log(Throwable throwable) {
        }

        public void printStackTrace(Throwable throwable) {
        }
    }
}

