/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class MsBuildParser
extends RegexpLineParser {
    static final String WARNING_TYPE = "MSBuild";
    private static final String MS_BUILD_WARNING_PATTERN = "^(?:\\s*\\d+>)?(?:(?:(?:(.*)\\((\\d*).*\\)|.*LINK)\\s*:|(.*):)\\s*([Nn]ote|[Ii]nfo|[Ww]arning|(?:fatal\\s*)?[Ee]rror)\\s*:?\\s*([A-Z0-9]+):\\s*(.*)|(.*)\\s*:.*error\\s*(LNK[0-9]+):\\s*(.*))$";

    public MsBuildParser() {
        super(MS_BUILD_WARNING_PATTERN, WARNING_TYPE);
    }

    protected Warning createWarning(Matcher matcher) {
        String fileName = this.determineFileName(matcher);
        if (StringUtils.isNotBlank((String)matcher.group(7))) {
            return new Warning(fileName, 0, this.getName(), matcher.group(8), matcher.group(9), Priority.HIGH);
        }
        return new Warning(fileName, this.getLineNumber(matcher.group(2)), this.getName(), matcher.group(5), matcher.group(6), this.determinePriority(matcher));
    }

    private String determineFileName(Matcher matcher) {
        String fileName = StringUtils.isNotBlank((String)matcher.group(3)) ? matcher.group(3) : (StringUtils.isNotBlank((String)matcher.group(7)) ? matcher.group(7) : matcher.group(1));
        if (StringUtils.isBlank((String)fileName)) {
            fileName = StringUtils.substringBetween((String)matcher.group(6), (String)"'");
        }
        if (StringUtils.isBlank((String)fileName)) {
            fileName = "unknown.file";
        }
        return fileName;
    }

    private Priority determinePriority(Matcher matcher) {
        if (this.isOfType(matcher, "note") || this.isOfType(matcher, "info")) {
            return Priority.LOW;
        }
        if (this.isOfType(matcher, "warning")) {
            return Priority.NORMAL;
        }
        return Priority.HIGH;
    }

    private boolean isOfType(Matcher matcher, String type) {
        return StringUtils.containsIgnoreCase((String)matcher.group(4), (String)type);
    }
}

