/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.parser.Warning;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class GroovyExpressionMatcher {
    private final String script;
    private final Warning falsePositive;
    private static final Logger LOGGER = Logger.getLogger(GroovyExpressionMatcher.class.getName());

    public GroovyExpressionMatcher(String script, Warning falsePositive) {
        this.script = script;
        this.falsePositive = falsePositive;
    }

    public Warning createWarning(Matcher matcher) {
        Binding binding = new Binding();
        binding.setVariable("matcher", (Object)matcher);
        GroovyShell shell = new GroovyShell(WarningsDescriptor.class.getClassLoader(), binding);
        Object result = null;
        try {
            result = shell.evaluate(this.script);
            if (result instanceof Warning) {
                return (Warning)((Object)result);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Groovy dynamic warnings parser: exception during parsing: ", exception);
        }
        return this.falsePositive;
    }
}

