/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.model;

import hudson.FilePath;
import hudson.plugins.testlink.TestLinkReport;
import hudson.plugins.testlink.model.TestLink;
import hudson.plugins.testlink.model.TestLinkTestCase;
import hudson.plugins.testlink.model.TestLinkXmlHandler;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.framework.io.IOException2;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLinkParser
implements FilePath.FileCallable<TestLinkReport> {
    public static final String RESULT_FILE_NAME = "testlink.xml";
    private boolean LOG_ENABLED = false;
    private transient PrintStream logger;

    public TestLinkParser(PrintStream logger) {
        this.logger = logger;
    }

    public TestLinkReport invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        TestLinkReport report = new TestLinkReport();
        this.parse(workspace, RESULT_FILE_NAME, report);
        return report;
    }

    private void parse(File workspace, String fileName, TestLinkReport report) throws IOException {
        File file = new File(workspace, fileName);
        FileInputStream in = new FileInputStream(file);
        this.parse(in, report);
        ((InputStream)in).close();
    }

    private void parse(InputStream in, TestLinkReport report) throws IOException {
        if (this.LOG_ENABLED && this.logger != null) {
            this.logger.println("Parsing testlink.xml file...");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
            // empty catch block
        }
        try {
            SAXParser parser = factory.newSAXParser();
            TestLinkXmlHandler handler = new TestLinkXmlHandler();
            parser.parse(in, (DefaultHandler)handler);
            TestLink testLink = handler.getTestLink();
            report.setBuildId(testLink.getBuildId());
            report.setBuildName(testLink.getBuildName());
            List<TestLinkTestCase> testCases = testLink.getTestCases();
            for (TestLinkTestCase tc : testCases) {
                report.addTestCase(tc);
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException2("Cannot parse testlink results", (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOException2("Cannot parse testlink results", (Throwable)e);
        }
    }
}

