/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import hudson.plugins.testlink.model.TestLinkTestCase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLinkReport
implements Serializable {
    private int testsFailed = 0;
    private int testsPassed = 0;
    private int testsBlocked = 0;
    private int testsTotal = 0;
    private List<TestLinkTestCase> testCases = new ArrayList<TestLinkTestCase>();
    private String buildName = null;
    private Integer buildId = 0;

    public int getTestsFailed() {
        return this.testsFailed;
    }

    public int getTestsPassed() {
        return this.testsPassed;
    }

    public int getTestsBlocked() {
        return this.testsBlocked;
    }

    public int getTestsTotal() {
        return this.testsFailed + this.testsPassed + this.testsBlocked;
    }

    public List<TestLinkTestCase> getListOfTestCases() {
        return this.testCases;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public Integer getBuildId() {
        return this.buildId;
    }

    public void setBuildId(Integer buildId) {
        this.buildId = buildId;
    }

    public String toString() {
        return "TestLinkReport [testsBlocked=" + this.testsBlocked + ", testsFailed=" + this.testsFailed + ", testsTotal=" + this.testsTotal + ", testsPassed=" + this.testsPassed + "]";
    }

    public void addTestCase(TestLinkTestCase tc) {
        this.testCases.add(tc);
        String testResultStatus = tc.getResultStatus();
        if (!StringUtils.isEmpty((String)testResultStatus)) {
            if (testResultStatus.equals("b")) {
                ++this.testsBlocked;
            } else if (testResultStatus.equals("f")) {
                ++this.testsFailed;
            } else if (testResultStatus.equals("p")) {
                ++this.testsPassed;
            }
        }
    }
}

