/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import hudson.plugins.testlink.TestLinkBuildAction;
import hudson.plugins.testlink.util.ChartUtil;
import hudson.util.Graph;
import java.io.IOException;
import java.io.Serializable;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLinkProjectAction
extends Actionable
implements ProminentProjectAction,
Serializable {
    public static final String DISPLAY_NAME = "TestLink Results";
    public static final String ICON_FILE_NAME = "/plugin/testlink/icons/testlink-24.png";
    public static final String URL_NAME = "testLinkResult";
    public static final int CHART_WIDTH = 500;
    public static final int CHART_HEIGHT = 200;
    private AbstractProject<?, ?> project;

    public TestLinkProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getIconFileName() {
        return ICON_FILE_NAME;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getSearchUrl() {
        return URL_NAME;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild<?, ?> build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), URL_NAME));
        }
    }

    private AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(TestLinkBuildAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public void doTrendMap(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild<?, ?> lastBuild = this.getLastFinishedBuild();
        TestLinkBuildAction lastAction = (TestLinkBuildAction)lastBuild.getAction(TestLinkBuildAction.class);
        XYDataset dataset = ChartUtil.createXYDataset(lastAction);
        final JFreeChart chart = ChartUtil.buildXYChart(dataset);
        new Graph(-1L, 500, 200){

            protected JFreeChart createGraph() {
                return chart;
            }
        }.doMap(request, response);
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild<?, ?> lastBuild = this.getLastFinishedBuild();
        TestLinkBuildAction lastAction = (TestLinkBuildAction)lastBuild.getAction(TestLinkBuildAction.class);
        XYDataset dataset = ChartUtil.createXYDataset(lastAction);
        final JFreeChart chart = ChartUtil.buildXYChart(dataset);
        new Graph(-1L, 500, 200){

            protected JFreeChart createGraph() {
                return chart;
            }
        }.doPng(request, response);
    }

    public final boolean hasValidResults() {
        TestLinkBuildAction resultAction;
        AbstractBuild<?, ?> build = this.getLastFinishedBuild();
        if (build != null && (resultAction = (TestLinkBuildAction)build.getAction(TestLinkBuildAction.class)) != null) {
            return resultAction.getPreviousResult() != null;
        }
        return false;
    }
}

