/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.pmd.PmdAnnotationsAggregator;
import hudson.plugins.pmd.PmdDescriptor;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.parser.PmdParser;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PmdPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 6711252664481150129L;
    private static final String PLUGIN_NAME = "PMD";
    private static final String DEFAULT_PATTERN = "**/pmd.xml";
    private String pattern;

    @DataBoundConstructor
    public PmdPublisher() {
        super(PLUGIN_NAME);
    }

    public String getPattern() {
        return this.pattern;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public BuildResult perform(Run<?, ?> build, FilePath workspace, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Collecting PMD analysis files...");
        FilesParser parser = new FilesParser(PLUGIN_NAME, StringUtils.defaultIfEmpty((String)this.expandFilePattern(this.getPattern(), build.getEnvironment(TaskListener.NULL)), (String)DEFAULT_PATTERN), (AnnotationParser)new PmdParser(this.getDefaultEncoding()), this.shouldDetectModules(), this.isMavenBuild(build));
        ParserResult project = (ParserResult)workspace.act((FilePath.FileCallable)parser);
        logger.logLines(project.getLogMessages());
        this.blame(project.getAnnotations(), build, workspace);
        PmdResult result = new PmdResult(build, this.getDefaultEncoding(), project, this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
        build.addAction((Action)new PmdResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public PmdDescriptor getDescriptor() {
        return (PmdDescriptor)super.getDescriptor();
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new PmdAnnotationsAggregator(build, launcher, listener, (HealthDescriptor)this, this.getDefaultEncoding(), this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
    }
}

