/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.impl;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.hipchat.CardProvider;
import jenkins.plugins.hipchat.CardProviderDescriptor;
import jenkins.plugins.hipchat.Messages;
import jenkins.plugins.hipchat.model.notifications.Activity;
import jenkins.plugins.hipchat.model.notifications.Attribute;
import jenkins.plugins.hipchat.model.notifications.Card;
import jenkins.plugins.hipchat.model.notifications.Icon;
import jenkins.plugins.hipchat.model.notifications.Value;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

@Extension
public class DefaultCardProvider
extends CardProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultCardProvider.class.getName());

    @Override
    public Card getCard(Run<?, ?> run, TaskListener taskListener, Icon icon, String message) {
        if (icon == null) {
            icon = new Icon().withUrl("https://bit.ly/2ctIstd");
        }
        try {
            return new Card().withStyle(Card.Style.APPLICATION).withUrl(TokenMacro.expandAll(run, null, (TaskListener)taskListener, (String)"${BUILD_URL}")).withFormat(Card.Format.MEDIUM).withId(UUID.randomUUID().toString()).withTitle(TokenMacro.expandAll(run, null, (TaskListener)taskListener, (String)Messages.CardTitle(), (boolean)false, null)).withIcon(icon).withAttributes(this.getAttributes(run, taskListener)).withActivity(new Activity().withHtml(message).withIcon(icon));
        }
        catch (IOException | MacroEvaluationException ex) {
            LOGGER.log(Level.WARNING, "Failed to resolve token macros", ex);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private List<Attribute> getAttributes(Run<?, ?> run, TaskListener taskListener) throws IOException, InterruptedException {
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        if (run.getAction(AbstractTestResultAction.class) != null) {
            try {
                String count = TokenMacro.expand(run, null, (TaskListener)taskListener, (String)"${TEST_COUNTS,var=\"pass\"}");
                if (StringUtils.isNotEmpty((String)count)) {
                    ret.add(this.attribute(Messages.TestsSuccessful(), count, "0".equals(count) ? Value.Style.LOZENGE_ERROR : Value.Style.LOZENGE_SUCCESS, null));
                }
                if (StringUtils.isNotEmpty((String)(count = TokenMacro.expand(run, null, (TaskListener)taskListener, (String)"${TEST_COUNTS,var=\"fail\"}")))) {
                    ret.add(this.attribute(Messages.TestsFailed(), count, "0".equals(count) ? Value.Style.LOZENGE_SUCCESS : Value.Style.LOZENGE_ERROR, null));
                }
                if (StringUtils.isNotEmpty((String)(count = TokenMacro.expand(run, null, (TaskListener)taskListener, (String)"${TEST_COUNTS,var=\"skip\"}")))) {
                    ret.add(this.attribute(Messages.TestsSkipped(), count, "0".equals(count) ? Value.Style.LOZENGE_SUCCESS : Value.Style.LOZENGE_CURRENT, null));
                }
                if (!ret.isEmpty()) {
                    ret.add(this.attribute(Messages.TestReport(), Messages.Here(), null, TokenMacro.expand(run, null, (TaskListener)taskListener, (String)"${TEST_REPORT_URL}")));
                }
            }
            catch (MacroEvaluationException mee) {
                taskListener.getLogger().println(Messages.UnresolvedMacro(mee.getMessage()));
            }
        }
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public CardProviderDescriptor getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends CardProviderDescriptor {
        public String getDisplayName() {
            return Messages.DefaultCardProvider();
        }
    }
}

