/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.ext.tokens;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.CauseAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.hipchat.Messages;
import jenkins.plugins.hipchat.utils.TokenMacroUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

@Extension
public class HipchatChangesMacro
extends TokenMacro {
    private static final Logger LOGGER = Logger.getLogger(HipchatChangesMacro.class.getName());
    private static final List<String> SUPPORTED_TOKENS = ImmutableList.of((Object)"HIPCHAT_CHANGES", (Object)"HIPCHAT_CHANGES_OR_CAUSE");

    public boolean acceptsMacroName(String macroName) {
        return SUPPORTED_TOKENS.contains(macroName);
    }

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName, Map<String, String> arguments, ListMultimap<String, String> argumentMultimap) {
        ChangeLogSet changeLogSet = null;
        if (!context.hasChangeSetComputed()) {
            LOGGER.log(Level.FINE, "No changeset computed for job {0}", context.getProject().getFullDisplayName());
        } else {
            changeLogSet = context.getChangeSet();
        }
        return this.getChangesOrCause((Run<?, ?>)context, (ChangeLogSet<? extends ChangeLogSet.Entry>)changeLogSet, macroName);
    }

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName, Map<String, String> arguments, ListMultimap<String, String> argumentMultimap) {
        if (run instanceof AbstractBuild) {
            return this.evaluate((AbstractBuild)run, listener, macroName, arguments, argumentMultimap);
        }
        return this.getChangesOrCause(run, TokenMacroUtils.getFirstChangeSet(run), macroName);
    }

    public List<String> getAcceptedMacroNames() {
        return SUPPORTED_TOKENS;
    }

    private String getChangesOrCause(Run<?, ?> run, ChangeLogSet<? extends ChangeLogSet.Entry> changeSet, String macroName) {
        String changes = null;
        if (changeSet != null) {
            HashSet authors = Sets.newHashSet();
            int changedFiles = 0;
            for (Object o : changeSet.getItems()) {
                ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
                LOGGER.log(Level.FINEST, "Entry {0}", entry);
                User author = entry.getAuthor();
                if (author == null) {
                    author = User.getUnknown();
                }
                authors.add(author.getDisplayName());
                try {
                    changedFiles += entry.getAffectedFiles().size();
                }
                catch (UnsupportedOperationException uoe) {
                    LOGGER.log(Level.FINE, "Unable to collect the affected files", uoe);
                }
            }
            if (changedFiles == 0 && authors.isEmpty()) {
                LOGGER.log(Level.FINE, "No changes detected");
            } else {
                changes = Messages.StartWithChanges(StringUtils.join((Collection)authors, (String)", "), changedFiles);
            }
        }
        if ("HIPCHAT_CHANGES".equals(macroName)) {
            return changes != null ? changes : Messages.NoChanges();
        }
        return changes != null ? changes : this.getCause(run);
    }

    private String getCause(Run<?, ?> context) {
        CauseAction cause = (CauseAction)context.getAction(CauseAction.class);
        if (cause != null) {
            return cause.getShortDescription();
        }
        return "";
    }
}

