/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat;

import hudson.ProxyConfiguration;
import hudson.Util;
import java.io.Closeable;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.plugins.hipchat.exceptions.NotificationException;
import jenkins.plugins.hipchat.ext.httpclient.ProxyRoutePlanner;
import jenkins.plugins.hipchat.ext.httpclient.TLSSocketFactory;
import jenkins.plugins.hipchat.model.notifications.Notification;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.util.EntityUtils;

public abstract class HipChatService {
    private static final Integer DEFAULT_TIMEOUT = 10000;

    protected CloseableHttpClient getHttpClient() {
        ProxyConfiguration proxy;
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(DEFAULT_TIMEOUT.intValue()).setSocketTimeout(DEFAULT_TIMEOUT.intValue()).build()).setSSLSocketFactory((LayeredConnectionSocketFactory)new TLSSocketFactory());
        if (Jenkins.getInstance() != null && (proxy = Jenkins.getInstance().proxy) != null) {
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new ProxyRoutePlanner(proxy));
            if (Util.fixEmpty((String)proxy.getUserName()) != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxy.name, proxy.port), (Credentials)new UsernamePasswordCredentials(proxy.getUserName(), proxy.getPassword()));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                httpClientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
            }
        }
        return httpClientBuilder.build();
    }

    @Deprecated
    public final void publish(String message, String color) throws NotificationException {
        this.publish(message, color, !color.equalsIgnoreCase("green"));
    }

    public void publish(String message, String color, boolean notify) throws NotificationException {
        this.publish(message, color, notify, false);
    }

    public void publish(String message, String color, boolean notify, boolean textFormat) throws NotificationException {
        this.publish(new Notification().withMessage(message).withColor(Notification.Color.fromValue(color)).withNotify(notify).withMessageFormat(textFormat ? Notification.MessageFormat.TEXT : Notification.MessageFormat.HTML));
    }

    public abstract void publish(Notification var1) throws NotificationException;

    protected final String readResponse(HttpEntity entity) throws IOException {
        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
    }

    protected final void closeQuietly(Closeable ... closeables) {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

