/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.dashboard;

import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.graph.CategoryBuildResultGraph;
import hudson.plugins.analysis.graph.ColorPalette;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.util.BoxRenderer;
import hudson.plugins.analysis.util.CategoryUrlBuilder;
import hudson.plugins.analysis.util.SerializableToolTipGenerator;
import hudson.plugins.analysis.util.SerializableUrlGenerator;
import hudson.plugins.analysis.util.ToolTipBoxRenderer;
import hudson.plugins.analysis.util.ToolTipBuilder;
import hudson.plugins.analysis.util.ToolTipProvider;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.Messages;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

public class FindbugsEvaluationsGraph
extends CategoryBuildResultGraph {
    public String getId() {
        return "EVALS";
    }

    public String getLabel() {
        return Messages.FindBugs_EvaluationsGraph_title();
    }

    protected List<Integer> computeSeries(BuildResult current) {
        ArrayList<Integer> series = new ArrayList<Integer>();
        if (current instanceof FindBugsResult) {
            FindBugsResult findBugsResult = (FindBugsResult)current;
            series.add(findBugsResult.getNumberOfComments());
        }
        return series;
    }

    protected JFreeChart createChart(CategoryDataset dataSet) {
        return this.createBlockChart(dataSet);
    }

    protected Color[] getColors() {
        return new Color[]{ColorPalette.BLUE};
    }

    protected CategoryItemRenderer createRenderer(GraphConfiguration configuration, String pluginName, ToolTipProvider toolTipProvider) {
        UrlBuilder url = new UrlBuilder(this.getRootUrl(), pluginName);
        DescriptionBuilder toolTip = new DescriptionBuilder(toolTipProvider);
        if (configuration.useBuildDateAsDomain()) {
            return new ToolTipBoxRenderer((SerializableToolTipGenerator)toolTip);
        }
        return new BoxRenderer((SerializableUrlGenerator)url, (SerializableToolTipGenerator)toolTip);
    }

    private static final class UrlBuilder
    extends CategoryUrlBuilder {
        private static final long serialVersionUID = 6928145843235050754L;

        UrlBuilder(String rootUrl, String pluginName) {
            super(rootUrl, pluginName);
        }

        protected String getDetailUrl(int row) {
            if (row == 1) {
                return "fixed";
            }
            return "new";
        }
    }

    private static final class DescriptionBuilder
    extends ToolTipBuilder {
        private static final long serialVersionUID = -223463531447822459L;

        DescriptionBuilder(ToolTipProvider provider) {
            super(provider);
        }

        protected String getShortDescription(int row) {
            if (row == 1) {
                return hudson.plugins.analysis.Messages.Trend_Fixed();
            }
            return hudson.plugins.analysis.Messages.Trend_New();
        }
    }
}

