/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MojoInfo;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwareReporter;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.findbugs.FindBugsMavenResultAction;
import hudson.plugins.findbugs.FindBugsPlugin;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.findbugs.FindBugsReporterResult;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.parser.FindBugsParser;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;

public class FindBugsReporter
extends HealthAwareReporter<FindBugsResult> {
    private static final long serialVersionUID = -288391908253344862L;
    private static final String PLUGIN_NAME = "FINDBUGS";
    private static final String FINDBUGS_XML_FILE = "findbugsXml.xml";
    private static final String MAVEN_FINDBUGS_XML_FILE = "findbugs.xml";
    private final boolean isRankActivated;
    private final String excludePattern;
    private final String includePattern;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient String pattern;

    @DataBoundConstructor
    public FindBugsReporter(String healthy, String unHealthy, String thresholdLimit, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, boolean isRankActivated, boolean canComputeNew, String excludePattern, String includePattern) {
        super(healthy, unHealthy, thresholdLimit, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, usePreviousBuildAsReference, useStableBuildAsReference, canComputeNew, PLUGIN_NAME);
        this.isRankActivated = isRankActivated;
        this.excludePattern = excludePattern;
        this.includePattern = includePattern;
    }

    public boolean isRankActivated() {
        return this.isRankActivated;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    public boolean preExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener) throws InterruptedException, IOException {
        if ("findbugs".equals(mojo.getGoal())) {
            this.activateProperty(mojo, "xmlOutput");
            this.activateProperty(mojo, "findbugsXmlOutput");
        }
        return true;
    }

    private void activateProperty(MojoInfo mojo, String property) {
        XmlPlexusConfiguration configuration = (XmlPlexusConfiguration)mojo.configuration.getChild(property);
        if (configuration != null) {
            configuration.setValue("true");
        }
    }

    protected boolean acceptGoal(String goal) {
        return "findbugs".equals(goal) || "site".equals(goal);
    }

    public ParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PluginLogger logger) throws InterruptedException, IOException {
        ArrayList<String> sources = new ArrayList<String>(pom.getCompileSourceRoots());
        sources.addAll(pom.getTestCompileSourceRoots());
        FilesParser findBugsCollector = new FilesParser(PLUGIN_NAME, this.determineFileName(mojo), (AnnotationParser)new FindBugsParser(sources, this.isRankActivated, this.getExcludePattern(), this.getIncludePattern()), this.getModuleName(pom));
        return (ParserResult)this.getOutputPath(mojo, pom).act((FilePath.FileCallable)findBugsCollector);
    }

    private FilePath getOutputPath(MojoInfo mojo, MavenProject pom) {
        try {
            String configurationValue = (String)mojo.getConfigurationValue("findbugsXmlOutputDirectory", String.class);
            if (StringUtils.isNotBlank((String)configurationValue)) {
                return new FilePath((VirtualChannel)null, configurationValue);
            }
        }
        catch (ComponentConfigurationException componentConfigurationException) {
            // empty catch block
        }
        return this.getTargetPath(pom);
    }

    protected FindBugsResult createResult(MavenBuild build, ParserResult project) {
        return new FindBugsReporterResult((Run<?, ?>)build, this.getDefaultEncoding(), project, this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
    }

    protected MavenAggregatedReport createMavenAggregatedReport(MavenBuild build, FindBugsResult result) {
        return new FindBugsMavenResultAction((Run<?, ?>)build, (HealthDescriptor)this, this.getDefaultEncoding(), result);
    }

    private String determineFileName(MojoInfo mojo) {
        try {
            if (FindBugsPlugin.isFindBugs2x(mojo.mojoExecution)) {
                return FINDBUGS_XML_FILE;
            }
            Boolean isNativeFormat = (Boolean)mojo.getConfigurationValue("findbugsXmlOutput", Boolean.class);
            if (Boolean.FALSE.equals(isNativeFormat)) {
                return MAVEN_FINDBUGS_XML_FILE;
            }
        }
        catch (ComponentConfigurationException componentConfigurationException) {
            // empty catch block
        }
        return FINDBUGS_XML_FILE;
    }

    public List<FindBugsProjectAction> getProjectActions(MavenModule module) {
        return Collections.singletonList(new FindBugsProjectAction((Job<?, ?>)module, (Class<? extends ResultAction<FindBugsResult>>)this.getResultActionClass()));
    }

    protected Class<FindBugsMavenResultAction> getResultActionClass() {
        return FindBugsMavenResultAction.class;
    }
}

