/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.findbugs.FindBugsAnnotationsAggregator;
import hudson.plugins.findbugs.FindBugsDescriptor;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.parser.FindBugsParser;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class FindBugsPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = -5748362182226609649L;
    private static final String PLUGIN_NAME = "FINDBUGS";
    private static final String ANT_DEFAULT_PATTERN = "**/findbugs.xml";
    private static final String MAVEN_DEFAULT_PATTERN = "**/findbugsXml.xml";
    private String pattern;
    private boolean isRankActivated;
    private String excludePattern;
    private String includePattern;

    @DataBoundConstructor
    public FindBugsPublisher() {
        super(PLUGIN_NAME);
    }

    public boolean isRankActivated() {
        return this.isRankActivated;
    }

    public boolean isIsRankActivated() {
        return this.isRankActivated;
    }

    @DataBoundSetter
    public void setIsRankActivated(boolean isRankActivated) {
        this.isRankActivated = isRankActivated;
    }

    public String getPattern() {
        return this.pattern;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    @DataBoundSetter
    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    @DataBoundSetter
    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }

    public BuildResult perform(Run<?, ?> build, FilePath workspace, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Collecting findbugs analysis files...");
        boolean isMavenBuild = this.isMavenBuild(build);
        String defaultPattern = isMavenBuild ? MAVEN_DEFAULT_PATTERN : ANT_DEFAULT_PATTERN;
        FilesParser collector = new FilesParser(PLUGIN_NAME, StringUtils.defaultIfEmpty((String)this.expandFilePattern(this.getPattern(), build.getEnvironment(TaskListener.NULL)), (String)defaultPattern), (AnnotationParser)new FindBugsParser(this.isRankActivated, this.getExcludePattern(), this.getIncludePattern()), this.shouldDetectModules(), isMavenBuild);
        ParserResult project = (ParserResult)workspace.act((FilePath.FileCallable)collector);
        logger.logLines(project.getLogMessages());
        this.blame(project.getAnnotations(), build, workspace);
        FindBugsResult result = new FindBugsResult(build, this.getDefaultEncoding(), project, this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
        build.addAction((Action)new FindBugsResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public FindBugsDescriptor getDescriptor() {
        return (FindBugsDescriptor)super.getDescriptor();
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new FindBugsAnnotationsAggregator(build, launcher, listener, (HealthDescriptor)this, this.getDefaultEncoding(), this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
    }
}

