/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss;

import hudson.model.AbstractBuild;
import hudson.model.HealthReportingAction;
import hudson.plugins.cppncss.PluginImpl;
import hudson.plugins.cppncss.parser.StatisticsResult;
import hudson.plugins.cppncss.parser.StatisticsTotalResult;
import hudson.plugins.helpers.AbstractBuildAction;
import hudson.plugins.helpers.GraphHelper;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Calendar;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildReport<T extends AbstractBuild<?, ?>>
extends AbstractBuildAction<T>
implements HealthReportingAction {
    private final StatisticsResult results;
    private final StatisticsTotalResult totals;
    private final Integer functionCcnViolationThreshold;
    private final Integer functionNcssViolationThreshold;

    public AbstractBuildReport(StatisticsResult results, Integer functionCcnViolationThreshold, Integer functionNcssViolationThreshold) {
        this.results = results;
        this.functionCcnViolationThreshold = functionCcnViolationThreshold;
        this.functionNcssViolationThreshold = functionNcssViolationThreshold;
        this.totals = StatisticsResult.total(results);
    }

    public StatisticsResult getResults() {
        return this.results;
    }

    public StatisticsTotalResult getTotals() {
        return this.totals;
    }

    public Integer getFunctionCcnViolationThreshold() {
        return this.functionCcnViolationThreshold;
    }

    public Integer getFunctionNcssViolationThreshold() {
        return this.functionNcssViolationThreshold;
    }

    @Override
    public String getSummary() {
        AbstractBuild prevBuild;
        for (prevBuild = (AbstractBuild)this.getBuild().getPreviousBuild(); prevBuild != null && prevBuild.getAction(this.getClass()) == null; prevBuild = (AbstractBuild)prevBuild.getPreviousBuild()) {
        }
        if (prevBuild == null) {
            return this.totals.toSummary();
        }
        AbstractBuildReport action = (AbstractBuildReport)prevBuild.getAction(this.getClass());
        return this.totals.toSummary(action.getTotals());
    }

    public String getIconFileName() {
        return PluginImpl.ICON_FILE_NAME;
    }

    public String getDisplayName() {
        return PluginImpl.DISPLAY_NAME;
    }

    @Override
    public String getGraphName() {
        return PluginImpl.GRAPH_NAME;
    }

    public String getUrlName() {
        return PluginImpl.URL;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (GraphHelper.isGraphUnsupported()) {
            GraphHelper.redirectWhenGraphUnsupported(rsp, req);
            return;
        }
        Calendar t = this.getBuild().getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)GraphHelper.buildChart(this.getBuild(), this.functionCcnViolationThreshold, this.functionNcssViolationThreshold), (int)this.getGraphWidth(), (int)this.getGraphHeight());
    }

    @Override
    public boolean isGraphActive() {
        Object build = this.getBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (build.getAction(this.getClass()) != null) {
                ++numPoints;
            }
            build = (AbstractBuild)build.getPreviousBuild();
        }
        return true;
    }

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }
}

