/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.cppncss.CppNCSSGhostwriter;
import hudson.plugins.cppncss.CppNCSSHealthMetrics;
import hudson.plugins.cppncss.CppNCSSHealthTarget;
import hudson.plugins.cppncss.CppNCSSProjectIndividualReport;
import hudson.plugins.cppncss.PluginImpl;
import hudson.plugins.helpers.AbstractPublisherImpl;
import hudson.plugins.helpers.Ghostwriter;
import hudson.plugins.helpers.health.HealthMetric;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppNCSSPublisher
extends AbstractPublisherImpl {
    private String reportFilenamePattern;
    private Integer functionCcnViolationThreshold = 10;
    private Integer functionNcssViolationThreshold = 100;
    private CppNCSSHealthTarget[] targets;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CppNCSSPublisher(String reportFilenamePattern, Integer functionCcnViolationThreshold, Integer functionNcssViolationThreshold, CppNCSSHealthTarget[] targets) {
        reportFilenamePattern.getClass();
        this.reportFilenamePattern = reportFilenamePattern;
        this.functionCcnViolationThreshold = functionCcnViolationThreshold;
        this.functionNcssViolationThreshold = functionNcssViolationThreshold;
        this.targets = targets == null ? new CppNCSSHealthTarget[]{} : targets;
    }

    public String getReportFilenamePattern() {
        return this.reportFilenamePattern;
    }

    public Integer getFunctionCcnViolationThreshold() {
        return this.functionCcnViolationThreshold;
    }

    public Integer getFunctionNcssViolationThreshold() {
        return this.functionNcssViolationThreshold;
    }

    public CppNCSSHealthTarget[] getTargets() {
        return this.targets;
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CppNCSSProjectIndividualReport(project, this.functionCcnViolationThreshold, this.functionNcssViolationThreshold);
    }

    @Override
    protected Ghostwriter newGhostwriter() {
        return new CppNCSSGhostwriter(this.reportFilenamePattern, this.functionCcnViolationThreshold, this.functionNcssViolationThreshold, this.targets);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private DescriptorImpl() {
            super(CppNCSSPublisher.class);
        }

        public String getDisplayName() {
            return "Publish " + PluginImpl.DISPLAY_NAME;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ConvertUtils.register((Converter)CppNCSSHealthMetrics.CONVERTER, CppNCSSHealthMetrics.class);
            return (Publisher)req.bindJSON(CppNCSSPublisher.class, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public HealthMetric[] getMetrics() {
            return CppNCSSHealthMetrics.values();
        }
    }
}

