/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss;

import hudson.model.AbstractBuild;
import hudson.plugins.cppncss.AbstractBuildReport;
import hudson.plugins.cppncss.CppNCSSBuildIndividualReport;
import hudson.plugins.cppncss.parser.Statistic;
import hudson.plugins.helpers.health.HealthMetric;
import java.util.Collection;
import org.apache.commons.beanutils.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CppNCSSHealthMetrics implements HealthMetric<CppNCSSBuildIndividualReport>
{
    TOT_CCN_RATIO{

        public String getName() {
            return "Total CCN";
        }

        public float measure(CppNCSSBuildIndividualReport report) {
            float ccn = report.getTotals().getFileTotal().getCcn();
            return ccn;
        }

        public float measureNew(CppNCSSBuildIndividualReport observable) {
            return 1.measureNew(this, observable);
        }

        public float getBest() {
            return 0.0f;
        }

        public float getWorst() {
            return 1000.0f;
        }
    }
    ,
    AVG_FILE_CCN_RATIO{

        public String getName() {
            return "Average File CCN";
        }

        public float measure(CppNCSSBuildIndividualReport report) {
            float ccn = report.getTotals().getFileTotal().getCcn();
            float number_of_files = report.getResults().getFileResults().size();
            return ccn / number_of_files;
        }

        public float measureNew(CppNCSSBuildIndividualReport observable) {
            return 2.measureNew(this, observable);
        }

        public float getBest() {
            return 0.0f;
        }

        public float getWorst() {
            return 1000.0f;
        }
    }
    ,
    NUMBER_OF_CCN_VIOLATED_FUNCTION{

        public String getName() {
            return "Number of CCN violated functions";
        }

        public float measure(CppNCSSBuildIndividualReport report) {
            int totalViolations = 0;
            Collection<Statistic> functionResults = report.getResults().getFunctionResults();
            for (Statistic statistic : functionResults) {
                if (statistic.getCcn() < (long)report.getFunctionCcnViolationThreshold().intValue()) continue;
                ++totalViolations;
            }
            return totalViolations;
        }

        public float measureNew(CppNCSSBuildIndividualReport observable) {
            return 3.measureNew(this, observable);
        }

        public float getBest() {
            return 0.0f;
        }

        public float getWorst() {
            return 100.0f;
        }
    }
    ,
    UMBER_OF_NCSS_VIOLATED_FUNCTION{

        public String getName() {
            return "Number of NCSS violated functions";
        }

        public float measure(CppNCSSBuildIndividualReport report) {
            int totalViolations = 0;
            Collection<Statistic> functionResults = report.getResults().getFunctionResults();
            for (Statistic statistic : functionResults) {
                if (statistic.getNcss() < (long)report.getFunctionNcssViolationThreshold().intValue()) continue;
                ++totalViolations;
            }
            return totalViolations;
        }

        public float measureNew(CppNCSSBuildIndividualReport observable) {
            return 4.measureNew(this, observable);
        }

        public float getBest() {
            return 0.0f;
        }

        public float getWorst() {
            return 100.0f;
        }
    };

    static Converter CONVERTER;

    static float measureNew(CppNCSSHealthMetrics metrics, CppNCSSBuildIndividualReport observable) {
        float newValue = metrics.measure(observable);
        AbstractBuild previousBuild = (AbstractBuild)observable.getBuild().getPreviousBuild();
        if (previousBuild != null) {
            CppNCSSBuildIndividualReport action = (CppNCSSBuildIndividualReport)previousBuild.getAction(AbstractBuildReport.class);
            float oldValue = metrics.measure(action);
            return newValue - oldValue;
        }
        return 0.0f;
    }

    static {
        CONVERTER = new Converter(){

            public Object convert(Class aClass, Object o) {
                return CppNCSSHealthMetrics.valueOf(o.toString());
            }
        };
    }
}

