/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.RootAction;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.plugins.claim.ClaimBuildAction;
import hudson.util.RunList;
import java.util.ArrayList;
import org.kohsuke.stapler.Stapler;

@Extension
public class ClaimedBuildsReport
implements RootAction {
    public String getIconFileName() {
        return "orange-square.gif";
    }

    public String getUrlName() {
        return "/claims";
    }

    public Run getFirstFail(Run r) {
        Run lastGood = r.getPreviousNotFailedBuild();
        Run firstFail = lastGood == null ? r.getParent().getFirstBuild() : lastGood.getNextBuild();
        return firstFail;
    }

    public String getClaimantText(Run r) {
        ClaimBuildAction claim = (ClaimBuildAction)r.getAction(ClaimBuildAction.class);
        if (claim == null || !claim.isClaimed()) {
            return "unclaimed";
        }
        String reason = claim.getReason();
        if (reason != null) {
            return "claimed by " + claim.getClaimedBy() + " because: " + claim.getReason();
        }
        return "claimed by " + claim.getClaimedBy();
    }

    public View getOwner() {
        View view = (View)Stapler.getCurrentRequest().findAncestorObject(View.class);
        if (view != null) {
            return view;
        }
        return Hudson.getInstance().getPrimaryView();
    }

    public RunList getBuilds() {
        ArrayList<Run> lastBuilds = new ArrayList<Run>();
        for (TopLevelItem item : this.getOwner().getItems()) {
            Run lb;
            if (!(item instanceof Job)) continue;
            Job job = (Job)item;
            for (lb = job.getLastBuild(); lb != null && (lb.hasntStartedYet() || lb.isBuilding()); lb = lb.getPreviousBuild()) {
            }
            if (lb == null || lb.getAction(ClaimBuildAction.class) == null) continue;
            lastBuilds.add(lb);
        }
        return RunList.fromRuns(lastBuilds).failureOnly();
    }

    public String getDisplayName() {
        return "Claim Report";
    }
}

