/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.io;

import com.google.common.base.Preconditions;
import java.io.Writer;

public class StringBuilderWriter
extends Writer {
    private final StringBuilder buffer;

    public StringBuilderWriter() {
        this(new StringBuilder());
    }

    private StringBuilderWriter(StringBuilder buffer) {
        this.buffer = (StringBuilder)Preconditions.checkNotNull((Object)buffer);
        this.lock = buffer;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void write(int c) {
        this.buffer.append((char)c);
    }

    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buffer.append(cbuf, off, len);
    }

    public void write(String str) {
        this.buffer.append(str);
    }

    public void write(String str, int off, int len) {
        this.buffer.append(str.substring(off, off + len));
    }

    public StringBuilderWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(((Object)csq).toString());
        }
        return this;
    }

    public StringBuilderWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(((Object)cs.subSequence(start, end)).toString());
        return this;
    }

    public StringBuilderWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void flush() {
    }

    public void close() {
    }
}

