/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.tasks;

import com.google.common.base.Preconditions;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildStep;
import org.hudsonci.utils.tasks.TaskListenerLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.gossip.support.MuxLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationSupport<T extends BuildStep> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final T owner;
    protected final AbstractBuild<?, ?> build;
    protected final BuildListener listener;
    protected final TaskListenerLogger logger;
    protected final Logger muxlog;

    public OperationSupport(T owner, AbstractBuild<?, ?> build, BuildListener listener) {
        this.owner = (BuildStep)Preconditions.checkNotNull(owner);
        this.build = (AbstractBuild)Preconditions.checkNotNull(build);
        this.listener = (BuildListener)Preconditions.checkNotNull((Object)listener);
        this.logger = new TaskListenerLogger((TaskListener)listener);
        this.muxlog = MuxLoggerFactory.create((Logger[])new Logger[]{this.log, this.logger});
    }

    protected abstract boolean doExecute() throws Exception;

    protected void onFailure(Throwable cause) {
        this.logger.error("Failure: {}", cause.toString());
        this.log.trace("Failure details", cause);
    }
}

