/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.tasks;

import com.google.common.base.Preconditions;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.BuildStep;
import java.io.IOException;
import org.apache.commons.lang.time.StopWatch;
import org.hudsonci.utils.tasks.OperationFailure;
import org.hudsonci.utils.tasks.OperationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PerformOperation<T extends BuildStep>
extends OperationSupport<T> {
    protected final Launcher launcher;

    public PerformOperation(T owner, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        super(owner, build, listener);
        this.launcher = (Launcher)Preconditions.checkNotNull((Object)launcher);
    }

    public boolean execute() throws InterruptedException, IOException {
        StopWatch watch = new StopWatch();
        watch.start();
        this.log.debug("Executing");
        try {
            boolean result = this.doExecute();
            this.log.debug("Finished in {}", (Object)watch);
            return result;
        }
        catch (InterruptedException e) {
            this.log.debug("Failed after {}", (Object)watch);
            this.onFailure(e);
            throw e;
        }
        catch (IOException e) {
            this.log.debug("Failed after {}", (Object)watch);
            this.onFailure(e);
            throw e;
        }
        catch (Exception e) {
            this.log.debug("Failed after {}", (Object)watch);
            this.onFailure(e);
            throw new OperationFailure(e);
        }
    }
}

