/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.tasks;

import hudson.FilePath;
import hudson.Functions;
import hudson.os.PosixAPI;
import hudson.remoting.VirtualChannel;
import hudson.util.jna.GNUCLibrary;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chmod
implements FilePath.FileCallable<Void> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Chmod.class);
    private final int mode;

    public Chmod(int mode) {
        this.mode = mode;
    }

    public Void invoke(File file, VirtualChannel channel) throws IOException {
        if (!Functions.isWindows()) {
            this.process(file);
        }
        return null;
    }

    private void process(File file) {
        assert (file != null);
        if (file.isFile()) {
            if (Functions.isMustangOrAbove()) {
                if (!file.setExecutable(true, false)) {
                    log.error("Failed to chmod: {}", (Object)file);
                }
            } else {
                try {
                    GNUCLibrary.LIBC.chmod(file.getAbsolutePath(), this.mode);
                }
                catch (LinkageError e) {
                    PosixAPI.get().chmod(file.getAbsolutePath(), this.mode);
                }
            }
        } else {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.process(child);
                }
            }
        }
    }
}

