/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.List;
import java.util.function.Predicate;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolver;
import org.junit.support.testng.engine.ConfiguringListener;
import org.junit.support.testng.engine.DiscoveryListener;
import org.junit.support.testng.engine.ExecutionListener;
import org.junit.support.testng.engine.IsTestNGTestClass;
import org.junit.support.testng.engine.LoggingListener;
import org.junit.support.testng.engine.TestNGEngineDescriptor;
import org.junit.support.testng.engine.TestNGSelectorResolver;
import org.testng.CommandLineArgs;
import org.testng.ITestNGListener;
import org.testng.TestNG;
import org.testng.xml.XmlSuite;

public class TestNGTestEngine
implements TestEngine {
    private static final EngineDiscoveryRequestResolver<TestNGEngineDescriptor> DISCOVERY_REQUEST_RESOLVER = EngineDiscoveryRequestResolver.builder().addClassContainerSelectorResolver((Predicate)new IsTestNGTestClass()).addSelectorResolver(ctx -> new TestNGSelectorResolver(ctx.getClassNameFilter(), ((TestNGEngineDescriptor)ctx.getEngineDescriptor()).getTestDescriptorFactory())).build();

    public String getId() {
        return "testng";
    }

    public TestDescriptor discover(EngineDiscoveryRequest request, UniqueId uniqueId) {
        TestNGEngineDescriptor engineDescriptor = new TestNGEngineDescriptor(uniqueId);
        DISCOVERY_REQUEST_RESOLVER.resolve(request, (TestDescriptor)engineDescriptor);
        Class[] testClasses = engineDescriptor.getTestClasses();
        List<String> methodNames = engineDescriptor.getQualifiedMethodNames();
        ConfigurationParameters configurationParameters = request.getConfigurationParameters();
        DiscoveryListener listener = new DiscoveryListener(request, engineDescriptor);
        if (testClasses.length > 0) {
            TestNGTestEngine.withTemporarySystemProperty("testng.mode.dryrun", "true", () -> TestNGTestEngine.configureAndRun(configurationParameters, (ITestNGListener)listener, Configurer.testClasses(testClasses), Phase.DISCOVERY));
        }
        if (!methodNames.isEmpty()) {
            TestNGTestEngine.withTemporarySystemProperty("testng.mode.dryrun", "true", () -> TestNGTestEngine.configureAndRun(configurationParameters, (ITestNGListener)listener, Configurer.testMethods(methodNames), Phase.DISCOVERY));
        }
        listener.finalizeDiscovery();
        return engineDescriptor;
    }

    public void execute(ExecutionRequest request) {
        EngineExecutionListener listener = request.getEngineExecutionListener();
        TestNGEngineDescriptor engineDescriptor = (TestNGEngineDescriptor)request.getRootTestDescriptor();
        listener.executionStarted((TestDescriptor)engineDescriptor);
        engineDescriptor.prepareExecution();
        ExecutionListener executionListener = new ExecutionListener(listener, engineDescriptor);
        List<String> methodNames = engineDescriptor.getQualifiedMethodNames();
        if (!methodNames.isEmpty()) {
            TestNGTestEngine.configureAndRun(request.getConfigurationParameters(), (ITestNGListener)executionListener, Configurer.testMethods(methodNames), Phase.EXECUTION);
        }
        listener.executionFinished((TestDescriptor)engineDescriptor, executionListener.toEngineResult());
    }

    private static void configureAndRun(ConfigurationParameters configurationParameters, ITestNGListener listener, Configurer ... configurers) {
        CommandLineArgs commandLineArgs = new CommandLineArgs();
        for (Configurer configurer : configurers) {
            configurer.configure(commandLineArgs, configurationParameters);
        }
        configurationParameters.get("testng.groups").ifPresent(it -> {
            commandLineArgs.groups = it;
        });
        configurationParameters.get("testng.excludedGroups").ifPresent(it -> {
            commandLineArgs.excludedGroups = it;
        });
        ConfigurableTestNG testNG = new ConfigurableTestNG();
        testNG.configure(commandLineArgs);
        for (Configurer configurer : configurers) {
            configurer.configure(testNG, configurationParameters);
        }
        testNG.addListener((ITestNGListener)LoggingListener.INSTANCE);
        testNG.addListener((ITestNGListener)new ConfiguringListener(configurationParameters));
        testNG.addListener(listener);
        testNG.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void withTemporarySystemProperty(String key, String value, Runnable action) {
        String originalValue = System.getProperty(key);
        System.setProperty(key, value);
        try {
            action.run();
        }
        finally {
            if (originalValue == null) {
                System.getProperties().remove(key);
            } else {
                System.setProperty(key, originalValue);
            }
        }
    }

    static interface Configurer {
        public static Configurer testClasses(final Class<?>[] testClasses) {
            return new Configurer(){

                @Override
                public void configure(TestNG testNG, ConfigurationParameters config) {
                    testNG.setTestClasses(testClasses);
                }
            };
        }

        public static Configurer testMethods(final List<String> methodNames) {
            return new Configurer(){

                @Override
                public void configure(CommandLineArgs commandLineArgs, ConfigurationParameters config) {
                    commandLineArgs.commandLineMethods = methodNames;
                }
            };
        }

        default public void configure(TestNG testNG, ConfigurationParameters config) {
        }

        default public void configure(CommandLineArgs commandLineArgs, ConfigurationParameters config) {
        }
    }

    static enum Phase implements Configurer
    {
        DISCOVERY{

            @Override
            public void configure(TestNG testNG, ConfigurationParameters config) {
                testNG.setVerbose(0);
                testNG.setUseDefaultListeners(false);
            }
        }
        ,
        EXECUTION{

            @Override
            public void configure(TestNG testNG, ConfigurationParameters config) {
                testNG.setVerbose(config.get("testng.verbose", Integer::valueOf).orElse(0).intValue());
                testNG.setUseDefaultListeners(config.getBoolean("testng.useDefaultListeners").orElse(false).booleanValue());
                config.get("testng.outputDirectory").ifPresent(arg_0 -> ((TestNG)testNG).setOutputDirectory(arg_0));
                config.getBoolean("testng.preserveOrder").ifPresent(arg_0 -> ((TestNG)testNG).setPreserveOrder(arg_0));
                config.get("testng.parallel", XmlSuite.ParallelMode::getValidParallel).ifPresent(arg_0 -> ((TestNG)testNG).setParallel(arg_0));
                config.get("testng.threadCount", Integer::parseInt).ifPresent(arg_0 -> ((TestNG)testNG).setThreadCount(arg_0));
                config.get("testng.dataProviderThreadCount", Integer::parseInt).ifPresent(arg_0 -> ((TestNG)testNG).setDataProviderThreadCount(arg_0));
            }

            @Override
            public void configure(CommandLineArgs commandLineArgs, ConfigurationParameters config) {
                config.get("testng.listeners").ifPresent(listeners -> {
                    commandLineArgs.listener = listeners;
                });
            }
        };

    }

    private static class ConfigurableTestNG
    extends TestNG {
        private ConfigurableTestNG() {
        }

        protected void configure(CommandLineArgs cla) {
            super.configure(cla);
        }
    }
}

