/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import org.junit.platform.commons.support.ClassSupport;
import org.testng.ITestNGMethod;

class MethodSignature {
    final String methodName;
    final Class<?>[] parameterTypes;
    final String stringRepresentation;

    static MethodSignature from(ITestNGMethod method) {
        return new MethodSignature(method.getMethodName(), MethodSignature.getParameterTypes(method));
    }

    public static Class<?>[] getParameterTypes(ITestNGMethod method) {
        try {
            return method.getParameterTypes();
        }
        catch (NoSuchMethodError e) {
            return method.getConstructorOrMethod().getParameterTypes();
        }
    }

    private MethodSignature(String methodName, Class<?>[] parameterTypes) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.stringRepresentation = String.format("%s(%s)", methodName, ClassSupport.nullSafeToString((Class[])parameterTypes));
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

