/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.Collections;
import java.util.Set;
import org.junit.platform.commons.support.ClassSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.support.testng.engine.MethodSignature;
import org.testng.ITestResult;
import org.testng.internal.IParameterInfo;

class MethodDescriptor
extends AbstractTestDescriptor {
    static final String SEGMENT_TYPE = "method";
    final MethodSignature methodSignature;
    private final Set<TestTag> tags;
    private final TestDescriptor.Type type;

    protected MethodDescriptor(UniqueId uniqueId, String displayName, Class<?> sourceClass, MethodSignature methodSignature, Set<TestTag> tags, TestDescriptor.Type type) {
        super(uniqueId, displayName, (TestSource)MethodDescriptor.toMethodSource(sourceClass, methodSignature));
        this.methodSignature = methodSignature;
        this.tags = tags;
        this.type = type;
    }

    public Set<TestTag> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    private static MethodSource toMethodSource(Class<?> sourceClass, MethodSignature methodSignature) {
        return MethodSource.from((String)sourceClass.getName(), (String)methodSignature.methodName, (String)ClassSupport.nullSafeToString((Class[])methodSignature.parameterTypes));
    }

    static String toMethodId(ITestResult result, MethodSignature methodSignature) {
        String id = methodSignature.stringRepresentation;
        Object[] instances = result.getTestClass().getInstances(true);
        if (instances.length > 1) {
            Object instance = result.getInstance();
            int instanceIndex = 0;
            for (int i = 0; i < instances.length; ++i) {
                if (MethodDescriptor.unwrap(instances[i]) != instance) continue;
                instanceIndex = i;
                break;
            }
            id = id + "@" + instanceIndex;
        }
        return id;
    }

    private static Object unwrap(Object instance) {
        try {
            return IParameterInfo.embeddedInstance((Object)instance);
        }
        catch (NoClassDefFoundError ignored) {
            return instance;
        }
    }

    public TestDescriptor.Type getType() {
        return this.type;
    }

    public boolean mayRegisterTests() {
        return this.type == TestDescriptor.Type.CONTAINER;
    }

    MethodSource getMethodSource() {
        return this.getSource().map(it -> (MethodSource)it).get();
    }
}

