/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.writer;

public enum LineDelimiter {
    LF("\n"),
    CR("\r"),
    CRLF("\r\n"),
    PLATFORM(System.lineSeparator());

    private final String str;

    private LineDelimiter(String str) {
        this.str = str;
    }

    public static LineDelimiter of(String str) {
        return switch (str) {
            case "\r\n" -> CRLF;
            case "\n" -> LF;
            case "\r" -> CR;
            default -> throw new IllegalArgumentException("Unknown line delimiter: " + str);
        };
    }

    public String toString() {
        return this.str;
    }
}

